/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.kony.mobilefabric.util.FabricVersion;
import com.konylabs.middleware.common.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public final class BuildProperties {
    private static final String VERSION_LABEL = "Fabric-Version";
    protected static final String MANIFEST_FILENAME = "/META-INF/MANIFEST.MF";
    private final Properties buildProperties = new Properties();
    private static BuildProperties instance = null;
    private static final Logger LOGGER = Logger.getLogger(BuildProperties.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuildProperties(ServletContext servletContext) throws IOException {
        InputStream in = null;
        try {
            in = servletContext.getResourceAsStream(MANIFEST_FILENAME);
            if (in != null) {
                Manifest manifest = new Manifest(in);
                for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
                    this.buildPropertiesFromManifest(entry.getValue().entrySet());
                }
                this.buildPropertiesFromManifest(manifest.getMainAttributes().entrySet());
            }
        }
        finally {
            Closer.closeQuietly((Closeable)in);
        }
    }

    public static BuildProperties getInstance(ServletContext servletContext) {
        if (instance == null) {
            try {
                instance = new BuildProperties(servletContext);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error occurred while reading build properties file.", (Throwable)e);
            }
        }
        return instance;
    }

    public String getBuildVersion() {
        return this.buildProperties.getProperty(VERSION_LABEL);
    }

    public Properties getBuildProperties() {
        return this.buildProperties;
    }

    private void buildPropertiesFromManifest(Set<Map.Entry<Object, Object>> propertiesCollection) {
        for (Map.Entry<Object, Object> entry : propertiesCollection) {
            String manifestKey = entry.getKey().toString();
            String manifestValue = entry.getValue().toString();
            if (VERSION_LABEL.equals(manifestKey)) {
                manifestValue = FabricVersion.convertFabricVersion((String)manifestValue);
            }
            this.buildProperties.put(manifestKey, manifestValue);
        }
    }

    private BuildProperties() {
    }
}

