/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.kony.adapter.model.ByteRange;
import com.kony.adapter.model.DefaultByteRange;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ByteRangeUtil {
    public static boolean isRangeValid(String rangeHeader) {
        rangeHeader = rangeHeader.replaceAll(" ", "");
        return rangeHeader.matches("^bytes=\\d*-\\d*(,\\d*-\\d*)*$");
    }

    public static List<ByteRange> getStartAndEndPosition(String rangeHeader) {
        ArrayList<ByteRange> position = new ArrayList<ByteRange>();
        if (ByteRangeUtil.isRangeValid(rangeHeader)) {
            String[] allRequestedByteRanges;
            for (String eachBytes : allRequestedByteRanges = rangeHeader.substring(5).replaceAll("\\s+", "").replace("=", "").split(",")) {
                position.add(ByteRangeUtil.processByteRange(eachBytes));
            }
        }
        return position;
    }

    public static ByteRange processByteRange(String eachBytes) {
        DefaultByteRange defaultByteRange = new DefaultByteRange();
        String[] byteRangePosition = eachBytes.split("-");
        if (StringUtils.isNotBlank((String)byteRangePosition[0])) {
            defaultByteRange.setStart(new BigInteger(byteRangePosition[0]));
        }
        if (eachBytes.endsWith("-") && byteRangePosition.length == 1) {
            return defaultByteRange;
        }
        if (StringUtils.isNotBlank((String)byteRangePosition[1])) {
            defaultByteRange.setEnd(new BigInteger(byteRangePosition[1]));
        }
        return defaultByteRange;
    }
}

