/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.kony.middleware.dbcommons.entity.ServerCertificate;
import com.konylabs.middleware.utilities.MaskUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.X509TrustedCertificateBlock;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public final class CertificateUtil {
    private static final char DOMAIN_SEPERATOR_CHARACTER = ',';
    private static final Logger LOGGER = Logger.getLogger(CertificateUtil.class);

    public static List<String> getDomainsAsList(String domains) {
        if (StringUtils.isNotBlank((String)domains)) {
            return Arrays.stream(StringUtils.split((String)domains, (char)',')).map(String::trim).collect(Collectors.toList());
        }
        return new ArrayList<String>(0);
    }

    public static Certificate[] getCertificates(String certContent) throws CertificateException, IOException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(certContent));){
            Object certificate = null;
            while ((certificate = pemParser.readObject()) != null) {
                JcaX509CertificateConverter convertor = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider());
                if (certificate instanceof X509CertificateHolder) {
                    certificates.add(convertor.getCertificate((X509CertificateHolder)certificate));
                    continue;
                }
                if (!(certificate instanceof X509TrustedCertificateBlock)) continue;
                certificates.add(convertor.getCertificate(((X509TrustedCertificateBlock)certificate).getCertificateHolder()));
            }
        }
        return certificates.toArray(new Certificate[certificates.size()]);
    }

    public static Certificate getRootCertificate(String certContent) throws IOException, CertificateException {
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(certContent));){
            Object certificate = pemParser.readObject();
            X509Certificate x509Certificate = certificate instanceof X509CertificateHolder ? new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate((X509CertificateHolder)certificate) : null;
            return x509Certificate;
        }
    }

    public static SetMultimap<String, String> getAliasDomainMapping(List<ServerCertificate> certs) {
        HashMultimap aliasDomainMap = HashMultimap.create();
        certs.stream().filter(cert -> CollectionUtils.isNotEmpty(CertificateUtil.getDomainsAsList(cert.getDomains()))).forEach(arg_0 -> CertificateUtil.lambda$getAliasDomainMapping$1((SetMultimap)aliasDomainMap, arg_0));
        return aliasDomainMap;
    }

    public static PrivateKey getPrivateKey(ServerCertificate certDetails) {
        PrivateKey privateKey = null;
        try (PEMParser parser = new PEMParser((Reader)new StringReader(certDetails.getPrivatekeyContent()));){
            Object object = parser.readObject();
            JcaPEMKeyConverter convertor = new JcaPEMKeyConverter();
            if (object instanceof PEMEncryptedKeyPair && CertificateUtil.isPrivateKeyPasswordProvided(certDetails)) {
                PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)object;
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().setProvider((Provider)new BouncyCastleProvider()).build(certDetails.getPrivatekeyPassword().toCharArray());
                privateKey = convertor.getKeyPair(encryptedKeyPair.decryptKeyPair(decProv)).getPrivate();
            } else if (object instanceof PEMKeyPair) {
                KeyPair keyPair = convertor.getKeyPair((PEMKeyPair)object);
                privateKey = keyPair.getPrivate();
            } else if (object instanceof PrivateKeyInfo) {
                privateKey = convertor.getPrivateKey((PrivateKeyInfo)object);
            }
        }
        catch (PEMException e) {
            MaskUtils.maskTrace((String)("Error while Extracting PrivateKey from Pem file with id " + certDetails.getId()), (Throwable)e, (Logger)LOGGER);
        }
        catch (IOException e1) {
            MaskUtils.maskTrace((String)("Error while parsing the Pem file with id " + certDetails.getId()), (Throwable)e1, (Logger)LOGGER);
        }
        return privateKey;
    }

    public static Timestamp getExpiresOn(String certificateContent) throws CertificateException, IOException {
        X509Certificate certificate = (X509Certificate)CertificateUtil.getRootCertificate(certificateContent);
        return new Timestamp(certificate.getNotAfter().getTime());
    }

    public static String getSubjectDomains(String certificateContent) throws CertificateException, IOException {
        X509Certificate certificate = (X509Certificate)CertificateUtil.getRootCertificate(certificateContent);
        return Optional.ofNullable(certificate.getSubjectAlternativeNames()).map(Collection::stream).orElseGet(Stream::empty).filter(e -> (Integer)e.get(0) == 2).map(e -> (String)e.get(1)).collect(Collectors.joining(", "));
    }

    public static String getIsuerCN(String certificateContent) throws CertificateException, IOException {
        X500Name issuerPrinicipal = CertificateUtil.getCertificateHolder(certificateContent).getIssuer();
        return CertificateUtil.extractRDNValueAsString(issuerPrinicipal, BCStyle.CN);
    }

    public static String getSubjectOrganization(String certificateContent) throws CertificateException, IOException {
        X500Name principal = CertificateUtil.getCertificateHolder(certificateContent).getSubject();
        return CertificateUtil.extractRDNValueAsString(principal, BCStyle.O);
    }

    private static X509CertificateHolder getCertificateHolder(String certificateContent) throws CertificateException, IOException {
        X509Certificate certificate = (X509Certificate)CertificateUtil.getRootCertificate(certificateContent);
        return new X509CertificateHolder(certificate.getEncoded());
    }

    private static String extractRDNValueAsString(X500Name principal, ASN1ObjectIdentifier ansiObjID) {
        return ArrayUtils.isNotEmpty((Object[])principal.getRDNs(ansiObjID)) && principal.getRDNs(ansiObjID)[0].getFirst() != null ? IETFUtils.valueToString((ASN1Encodable)principal.getRDNs(ansiObjID)[0].getFirst().getValue()) : "";
    }

    private static boolean isPrivateKeyPasswordProvided(ServerCertificate certDetails) {
        return StringUtils.isNotBlank((String)certDetails.getPrivatekeyPassword());
    }

    public static boolean isTrustStoreCert(ServerCertificate certDetails) {
        return certDetails.getDiscriminator() == 't' || certDetails.getDiscriminator() == 'T';
    }

    public static boolean isKeyStoreCert(ServerCertificate certDetails) {
        return certDetails.getDiscriminator() == 'k' || certDetails.getDiscriminator() == 'K';
    }

    public static char[] getKeypassOrDefault(String keypass, char[] defaultKeyPass) {
        return StringUtils.isBlank((String)keypass) ? defaultKeyPass : keypass.toCharArray();
    }

    private CertificateUtil() {
    }

    private static /* synthetic */ void lambda$getAliasDomainMapping$1(SetMultimap aliasDomainMap, ServerCertificate cert) {
        aliasDomainMap.putAll((Object)cert.getAlias(), CertificateUtil.getDomainsAsList(cert.getDomains()));
    }
}

