/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.session.Session;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class CookieUtils {
    private static final Logger LOGGER = Logger.getLogger(CookieUtils.class);
    private static final String COOKIE_SEPERATOR = "; ";
    private static final Pattern COOKIE_PATTERN = Pattern.compile("([^=]+)=([^\\;]*);?\\s?");

    public static void checkCookiesInRequest(DataControllerRequest dcRequest, Map<String, String> headerMap) {
        String hcookie = dcRequest.getHeader("Cookie");
        String rcookie = headerMap.get("Cookie");
        String kookie = "";
        if (StringUtils.isBlank((String)hcookie) && StringUtils.isNotBlank((String)rcookie)) {
            kookie = rcookie;
        } else if (StringUtils.isNotBlank((String)hcookie) && StringUtils.isBlank((String)rcookie)) {
            kookie = hcookie;
        } else if (StringUtils.isNotBlank((String)hcookie) && StringUtils.isNotBlank((String)rcookie)) {
            String string = kookie = hcookie.endsWith(";") ? hcookie + rcookie : hcookie + COOKIE_SEPERATOR + rcookie;
        }
        if (StringUtils.isNotBlank((String)kookie)) {
            String[] cookies;
            Session session = dcRequest.getSession(false);
            for (String cookie : cookies = kookie.split(COOKIE_SEPERATOR)) {
                CookieUtils.parseCookieString(cookie, session);
            }
        }
    }

    private static void parseCookieString(String cookies, Session session) {
        Matcher matcher = COOKIE_PATTERN.matcher(cookies);
        String cookieKey = null;
        String cookieValue = null;
        String domain = "";
        String path = "/";
        boolean secure = false;
        while (matcher.find()) {
            int groupCount = matcher.groupCount();
            if (LOGGER.isDebugEnabled()) {
                for (int groupIndex = 0; groupIndex <= groupCount; ++groupIndex) {
                    LOGGER.debug((Object)("group[" + groupIndex + "]=" + matcher.group(groupIndex)));
                }
            }
            String key = matcher.group(1);
            String value = matcher.group(2);
            if ("domain".equalsIgnoreCase(key)) {
                domain = value;
                continue;
            }
            if ("path".equalsIgnoreCase(key)) {
                path = value;
                continue;
            }
            if ("secure".equalsIgnoreCase(key)) {
                secure = Boolean.valueOf(value);
                continue;
            }
            if ("cacheid".equalsIgnoreCase(key)) continue;
            cookieKey = key;
            cookieValue = value;
        }
        if (StringUtils.isNotBlank(cookieKey) && StringUtils.isNotBlank(cookieValue)) {
            if (StringUtils.isNotBlank((String)domain) || StringUtils.isNotBlank((String)path)) {
                session.addEISCookie(cookieKey, cookieValue, path, domain, secure);
            } else {
                session.addEISCookie(cookieKey, cookieValue);
            }
        }
    }

    private CookieUtils() {
    }
}

