/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.konylabs.middleware.utilities.EncodeUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;

public final class DigestUtil {
    private static final Logger LOGGER = Logger.getLogger(DigestUtil.class);
    private static final String DIGEST_ALGORITHM = "SHA-256";

    public static String digest(String plainText) {
        return DigestUtil.digest(plainText, DIGEST_ALGORITHM);
    }

    private static String digest(String plainText, String algorithm) {
        String result = null;
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] dataBytes = EncodeUtils.getBytes((String)plainText);
            md.update(dataBytes, 0, dataBytes.length);
            byte[] mdbytes = md.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < mdbytes.length; ++i) {
                String hex = Integer.toHexString(0xFF & mdbytes[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            result = hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private DigestUtil() {
    }
}

