/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.kony.api.gateway.GatewayException;
import com.konylabs.middleware.mbaas.MBAASGateWayWrapper;
import com.konylabs.middleware.request.HttpIntegrityInfo;
import com.konylabs.middleware.request.HttpIntegrityRequestWrapper;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.response.HttpIntegrityResponseWrapper;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public final class IntegrityUtils {
    private static final Logger LOGGER = Logger.getLogger(IntegrityUtils.class);

    public static HttpIntegrityInfo createIntegrityWrapperIfRequired(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RequestContext requestContext, MBAASGateWayWrapper mbaasGatewayWrapper) throws GatewayException, IOException {
        Object httpIntegrityRequestWrapper = httpServletRequest;
        Object httpIntegrityResponseWrapper = httpServletResponse;
        LOGGER.debug((Object)"Started integrity check.");
        if (mbaasGatewayWrapper != null && mbaasGatewayWrapper.getGateway() != null && mbaasGatewayWrapper.getGateway().isIntegrityCheckOrEncryptionRequired()) {
            if (!requestContext.isRequestpassthrough()) {
                LOGGER.debug((Object)"Creating HttpIntegrityRequestWrapper");
                httpIntegrityRequestWrapper = new HttpIntegrityRequestWrapper(httpServletRequest, mbaasGatewayWrapper.getGateway());
            }
            if (!requestContext.isResponsePassThrough()) {
                LOGGER.debug((Object)"Creating HttpIntegrityResponseWrapper");
                httpIntegrityResponseWrapper = new HttpIntegrityResponseWrapper(httpServletResponse, mbaasGatewayWrapper.getGateway(), httpServletRequest.getHeader("X-Kony-Integrity"), httpServletRequest.getContentType());
            }
        }
        return new HttpIntegrityInfo((HttpServletRequest)httpIntegrityRequestWrapper, (HttpServletResponse)httpIntegrityResponseWrapper);
    }

    private IntegrityUtils() {
    }
}

