/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.kony.mobilefabric.logger.DynamicLogCriteriaHelper;
import com.kony.mobilefabric.logger.DynamicLogFilter;
import com.kony.mobilefabric.logger.DynamicLogManager;
import com.kony.mobilefabric.util.HttpUtil;
import com.kony.mobilefabric.util.LogLevelConstants;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.config.AuditLogFilter;
import com.konylabs.middleware.config.DBConfigSubject;
import com.konylabs.middleware.config.DatasourcePayloadLogger;
import com.konylabs.middleware.config.DevicePayloadLogger;
import com.konylabs.middleware.config.LoggerProperties;
import com.konylabs.middleware.config.TraceLogProperties;
import com.konylabs.middleware.datasourcelogs.LogDataSourceData;
import com.konylabs.middleware.datasourcelogs.LogDeviceRequestData;
import com.konylabs.middleware.datasourcelogs.LogDeviceResponseData;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory;

public final class LoggerUtility {
    private static final Logger LOGGER = Logger.getLogger(LoggerUtility.class);
    private static final Object LOCK = new Object();
    public static final DynamicLogManager DYNAMIC_LOG_MANAGER = DynamicLogManager.create((String)"KONY_SERVER_DYNAMIC_LOG_LEVEL");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLog4jProperties(String log4jPropsFile, boolean isAdmin) {
        FileInputStream log4JConfig = null;
        try {
            System.out.println("Setting isThreadContextMapInheritable to true as System property");
            System.setProperty("isThreadContextMapInheritable", "true");
            System.out.println("Loading the log4j (for middleware) from  : " + log4jPropsFile);
            log4JConfig = new FileInputStream(log4jPropsFile);
            System.out.println("Start - Initializing log4j (without log4j hierarchy)...");
            ConfigurationSource source = new ConfigurationSource((InputStream)log4JConfig, new File(log4jPropsFile));
            LoggerContext loggerCtx = Configurator.initialize(null, (ConfigurationSource)source);
            if (!isAdmin) {
                loggerCtx.addFilter((Filter)DynamicLogFilter.create((String)"KONY_SERVER_DYNAMIC_LOG_LEVEL"));
            }
            loggerCtx.start(XmlConfigurationFactory.getInstance().getConfiguration(loggerCtx, source));
            LoggerUtility.updateLog4jLogLevel();
            if (!isAdmin) {
                LoggerUtility.updateLogFiltersInDynamicLogManager();
                LoggerUtility.updatePayloadLoggers();
                LoggerUtility.initializeTraceLogLevel();
            }
            System.out.println("End - Initializing log4j...");
            Closer.closeQuietly((Closeable)log4JConfig);
        }
        catch (Exception e) {
            System.out.println("Exception while loading middleware log4j properties ");
            e.printStackTrace();
        }
        finally {
            Closer.closeQuietly(log4JConfig);
        }
    }

    public static void updateLog4jLogLevel() {
        String persistedLevel = (String)LoggerProperties.SERVER_LOG_LEVEL.getFromConfig();
        if (StringUtils.isNotBlank((String)persistedLevel)) {
            LoggerUtility.updateRootLogger(persistedLevel);
        }
        LoggerUtility.updateCustomLoggers();
    }

    public static void updatePayloadLoggers() {
        String logDevicePayloads = (String)LoggerProperties.LOG_DEVICE_PAYLOAD.getFromConfig();
        LoggerUtility.updatePayloadLogger(logDevicePayloads, DevicePayloadLogger.class);
        String logDatasourcePayloads = (String)LoggerProperties.LOG_DATASOURCE_PAYLOAD.getFromConfig();
        LoggerUtility.updatePayloadLogger(logDatasourcePayloads, DatasourcePayloadLogger.class);
        String logAuditInfo = (String)LoggerProperties.LOG_AUDIT_INFO.getFromConfig();
        LoggerUtility.updatePayloadLogger(logAuditInfo, AuditLogFilter.class);
    }

    public static Level toLevel(String logLevel) {
        return Level.toLevel((String)logLevel, (Level)Level.ERROR);
    }

    public static void updateRootLogger(String logLevel) {
        LoggerUtility.updateLoggerLevel(LoggerUtility.toLevel(logLevel), "", "com.kony", "com.konylabs");
    }

    public static void updateTimerLogger(String logLevel) {
        LoggerUtility.updateLoggerLevel(LoggerUtility.toLevel(logLevel), "com.konylabs.middleware.timer", "com.konylabs.middleware.service", "com.konylabs.middleware.classloader", "com.kony.middleware.dbcommons.dao");
    }

    public static void updatePayloadLogger(String logPayload, Class<?> loggerName) {
        if ("1".equals(logPayload) || "true".equalsIgnoreCase(logPayload)) {
            LoggerUtility.updateLoggerLevel(Level.DEBUG, loggerName.getName());
        } else {
            LoggerUtility.updateLoggerLevel(Level.OFF, loggerName.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLoggerLevel(Level logLevel, String ... loggerNames) {
        if (logLevel != null && loggerNames != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Updating log levels. Level = " + logLevel + ", Loggers = " + Arrays.toString(loggerNames)));
            }
            Object object = LOCK;
            synchronized (object) {
                LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
                for (String loggerName : loggerNames) {
                    LoggerUtility.updateLogLevel(ctx, logLevel, loggerName);
                }
                ctx.updateLoggers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLoggerLevel(String loggerName) {
        Object object = LOCK;
        synchronized (object) {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            LoggerUtility.removeLogLevel(ctx, loggerName);
            ctx.updateLoggers();
        }
    }

    public static void matchAndSetDynamicLogLevel(HttpServletRequest request, HttpServletResponse response, String serviceId) {
        LoggerUtility.matchAndSetDynamicLogLevel(LoggerProperties.SERVICE_NAME_LOG_CRITERIA, serviceId);
        LoggerUtility.matchAndSetDynamicLogLevel(LoggerProperties.CLIENT_IP_LOG_CRITERIA, HttpUtil.getRemoteAddress((HttpServletRequest)request));
        LoggerUtility.matchAndSetDynamicLogLevel(LoggerProperties.DEVICE_ID_LOG_CRITERIA, request.getHeader("X-Kony-DeviceId"));
        LoggerUtility.matchAndSetDynamicLogLevel(LoggerProperties.CLIENT_LOG_LEVEL_OVERRIDE, request.getHeader("X-Kony-Log-Level-Override"));
    }

    public static void matchAndSetDynamicLogLevel(LoggerProperties property, String propValue) {
        DYNAMIC_LOG_MANAGER.matchAndSetLevel(property.getName(), propValue);
    }

    public static void addClientLogLevelInResponseHeader(HttpServletRequest request, HttpServletResponse response) {
        Level afterValue;
        Level previousValue = LoggerUtility.getLogLevelFromRequestHeader(request);
        if (previousValue != (afterValue = DynamicLogManager.getThreadContextLevel((String)"KONY_SERVER_DYNAMIC_LOG_LEVEL"))) {
            if (afterValue != LogLevelConstants.KONY_DEFAULT_OFF_LEVEL) {
                response.setHeader("X-KONY-DEVICE-LOG-LEVEL", afterValue.name());
            } else if (previousValue != null && previousValue != Level.OFF) {
                response.setHeader("X-KONY-DEVICE-LOG-LEVEL", Level.OFF.name());
            }
        }
    }

    public static void updateTraceLogsLevel(String level) {
        Level loggerLevel;
        switch (level) {
            case "ON": {
                loggerLevel = Level.TRACE;
                break;
            }
            case "MEDIUM": {
                loggerLevel = Level.DEBUG;
                break;
            }
            default: {
                loggerLevel = Level.OFF;
            }
        }
        LoggerUtility.updateLoggerLevel(loggerLevel, LogDeviceRequestData.class.getName(), LogDeviceResponseData.class.getName(), LogDataSourceData.class.getName());
    }

    public static void addDynamicLogCriteria(LoggerProperties criteria, String value) {
        DYNAMIC_LOG_MANAGER.add(criteria.getName(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCustomLoggers() {
        Map loggerLevelMap = DBConfigSubject.getInstance().getLoggerLevelMap();
        if (loggerLevelMap.size() > 0) {
            Object object = LOCK;
            synchronized (object) {
                LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
                for (Map.Entry entry : loggerLevelMap.entrySet()) {
                    String logLevel = (String)entry.getValue();
                    if (StringUtils.isBlank((String)logLevel)) {
                        LoggerUtility.removeLogLevel(ctx, (String)entry.getKey());
                        continue;
                    }
                    LoggerUtility.updateLogLevel(ctx, LoggerUtility.toLevel(logLevel), (String)entry.getKey());
                }
                ctx.updateLoggers();
            }
        }
    }

    private static void updateLogFiltersInDynamicLogManager() {
        LoggerUtility.addDynamicLogCriteria(LoggerProperties.TENANT_ID_LOG_CRITERIA);
        LoggerUtility.addDynamicLogCriteria(LoggerProperties.USER_ID_LOG_CRITERIA);
        LoggerUtility.addDynamicLogCriteria(LoggerProperties.CLIENT_IP_LOG_CRITERIA);
        LoggerUtility.addDynamicLogCriteria(LoggerProperties.DEVICE_ID_LOG_CRITERIA);
        LoggerUtility.addDynamicLogCriteria(LoggerProperties.SERVICE_NAME_LOG_CRITERIA);
        LoggerUtility.addDynamicLogCriteria(LoggerProperties.MFAPP_NAME_LOG_CRITERIA);
        DYNAMIC_LOG_MANAGER.add(DynamicLogCriteriaHelper.buildClientOverrideLogCriteria((String)LoggerProperties.CLIENT_LOG_LEVEL_OVERRIDE.getName(), (boolean)((Boolean)LoggerProperties.CLIENT_LOG_LEVEL_OVERRIDE.getFromConfig())));
    }

    private static void addDynamicLogCriteria(LoggerProperties criteria) {
        LoggerUtility.addDynamicLogCriteria(criteria, (String)criteria.getFromConfig());
    }

    private static Level getLogLevelFromRequestHeader(HttpServletRequest request) {
        String logLevel = request.getHeader("X-KONY-DEVICE-LOG-LEVEL");
        return logLevel != null ? Level.toLevel((String)logLevel, (Level)LogLevelConstants.KONY_DEFAULT_OFF_LEVEL) : null;
    }

    private static void updateLogLevel(LoggerContext ctx, Level logLevel, String loggerName) {
        Configuration config = ctx.getConfiguration();
        if (config.getLoggers().get(loggerName) != null) {
            LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
            if (loggerConfig != null && loggerConfig.getLevel() != logLevel) {
                loggerConfig.setLevel(logLevel);
            }
        } else {
            String logAppenderName = LoggerUtility.getLogAppenderName();
            Appender appender = config.getAppender(logAppenderName);
            AppenderRef middlewareRef = AppenderRef.createAppenderRef((String)logAppenderName, null, null);
            AppenderRef[] middlewareRefs = new AppenderRef[]{middlewareRef};
            LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)logLevel, (String)loggerName, (String)"true", (AppenderRef[])middlewareRefs, null, (Configuration)config, null);
            if (appender != null) {
                loggerConfig.addAppender(appender, null, null);
            }
            config.addLogger(loggerName, loggerConfig);
        }
    }

    private static String getLogAppenderName() {
        String logOption = (String)LoggerProperties.SERVER_LOG_OPTION.getFromConfig();
        if ("SYSLOG".equalsIgnoreCase(logOption)) {
            return "SYSLOGappender";
        }
        if ("database".equalsIgnoreCase(logOption)) {
            return "databaseappender";
        }
        return "logfileappender";
    }

    private static void removeLogLevel(LoggerContext ctx, String loggerName) {
        Configuration config = ctx.getConfiguration();
        if (config.getLoggers().get(loggerName) != null) {
            config.removeLogger(loggerName);
        }
    }

    static void initializeTraceLogLevel() {
        String traceLogLevel = (String)TraceLogProperties.LEVEL.getFromConfig();
        LoggerUtility.updateTraceLogsLevel(traceLogLevel);
    }

    private LoggerUtility() {
    }
}

