/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.google.gson.JsonElement;
import com.kony.adapter.DataAdapter;
import com.kony.adapter.criteria.ColumnOrder;
import com.kony.adapter.criteria.CompositeFilter;
import com.kony.adapter.criteria.Criteria;
import com.kony.adapter.criteria.Filter;
import com.kony.adapter.criteria.IFilter;
import com.kony.adapter.criteria.TreeNode;
import com.kony.adapter.event.DataAdapterEvent;
import com.kony.adapter.event.DataAdapterEventNotifier;
import com.kony.adapter.event.DataAdapterEventType;
import com.kony.adapter.event.EventDetail;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.metadata.model.EntityMetadata;
import com.kony.adapter.model.Entity;
import com.kony.adapter.service.runtime.ServiceData;
import com.kony.adapter.util.criteria.CriteriaBuilderFactory;
import com.kony.mapper.MapperEngine;
import com.kony.mapper.exception.MapperException;
import com.kony.mapper.exception.MapperRuntimeException;
import com.kony.mapper.javascript.JavaScriptEngineWrapper;
import com.kony.mapper.model.AbstractNodeCreator;
import com.kony.mapper.model.Node;
import com.kony.mapper.model.NodeCreator;
import com.kony.mapper.model.NodeElement;
import com.kony.mapper.registry.vo.Function;
import com.kony.mapper.registry.vo.Functions;
import com.kony.mapper.registry.vo.Mapper;
import com.kony.mapper.util.JsonMapperUtility;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.DataAdapterConnectorException;
import com.konylabs.middleware.mapper.CriteriaNode;
import com.konylabs.middleware.mapper.DCRNodeFactory;
import com.konylabs.middleware.mapper.EntityNode;
import com.konylabs.middleware.mapper.EntityNodeCreator;
import com.konylabs.middleware.mapper.IdentityNode;
import com.konylabs.middleware.mapper.MapNode;
import com.konylabs.middleware.mapper.ResultNode;
import com.konylabs.middleware.mapper.ResultNodeCreator;
import com.konylabs.middleware.mapper.RowNodeCreator;
import com.konylabs.middleware.mapper.ServiceDataInputNodeCreator;
import com.konylabs.middleware.mapper.ServiceDataNode;
import com.konylabs.middleware.mapper.ServiceInputNode;
import com.konylabs.middleware.mapper.ServiceInputNodeCreator;
import com.konylabs.middleware.mapper.ServiceOutputNode;
import com.konylabs.middleware.mapper.SessionNode;
import com.konylabs.middleware.mbaas.MiddlewareMBaasUtils;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.request.builder.ResultRow;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.utilities.EncodeUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class MapperUtility {
    private static final Logger LOGGER = Logger.getLogger(MapperUtility.class);

    public static Criteria applyMapperOnCriteria(Service service, Criteria criteria, Map<String, String> fieldMap) throws DataAdapterConnectorException {
        try {
            List<TreeNode<String>> currentObjectTree;
            TreeNode<String> currentObject;
            LOGGER.debug((Object)("Applying the criteria based on the mapper for service " + service.getId()));
            Map<String, List<TreeNode<String>>> srcTreeMap = MiddlewareUtils.getServiceMetadata(service).getObjectSrcNodeMap();
            boolean hasMultipleObjMappings = false;
            Criteria finalcriteria = new Criteria();
            TreeNode finalExpandTreeNode = finalcriteria.getExpandTree();
            if (criteria != null && fieldMap != null && fieldMap.size() != 0) {
                MapperUtility.applyMapperOnFilter(criteria, finalcriteria, fieldMap);
                MapperUtility.applyMapperOnOrderBy(criteria, finalcriteria, fieldMap);
                MapperUtility.applyMapperOnSelect(criteria, finalcriteria, fieldMap);
                TreeNode expandTreeNode = criteria.getExpandTree();
                MapperUtility.expandHierarchy((TreeNode<String>)finalExpandTreeNode, (TreeNode<String>)expandTreeNode, srcTreeMap);
            }
            TreeNode<String> treeNode = currentObject = (currentObjectTree = srcTreeMap.get(MiddlewareUtils.getServiceMetadata(service).getObjectId())) != null && !currentObjectTree.isEmpty() ? currentObjectTree.get(0) : null;
            if (currentObject != null) {
                List childTreeList = currentObject.getChildren();
                for (TreeNode childTree : childTreeList) {
                    hasMultipleObjMappings = true;
                    finalExpandTreeNode.addChildNode(childTree);
                }
            }
            if (criteria == null && !hasMultipleObjMappings) {
                return criteria;
            }
            finalcriteria.setExpandTree(finalExpandTreeNode);
            return finalcriteria;
        }
        catch (DataAdapterConnectorException ex) {
            LOGGER.error((Object)"DataAdapterConnectorException in applyMapperOnCriteria", (Throwable)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"exception in applyMapperOnCriteria", (Throwable)ex);
            String errorCode = DataAdapterConnectorException.ERROR_MAPPER_UTILITY;
            String errorMessage = DataAdapterConnectorException.getErrorCodeMessage(errorCode);
            throw new DataAdapterConnectorException(errorCode, errorMessage);
        }
    }

    public static void applyMapperOnSelect(Criteria criteria, Criteria finalcriteria, Map<String, String> fieldMap) {
        LOGGER.debug((Object)"Inside applyMapperOnSelect method.");
        if (criteria == null || finalcriteria == null) {
            return;
        }
        List selectFields = criteria.getSelectFields();
        for (String field : selectFields) {
            String mappedColumn = MapperUtility.getMappedValue(fieldMap, field);
            if (mappedColumn == null || mappedColumn.isEmpty()) continue;
            finalcriteria.addSelectField(mappedColumn);
        }
    }

    public static void applyMapperOnOrderBy(Criteria criteria, Criteria finalcriteria, Map<String, String> fieldMap) {
        LOGGER.debug((Object)"Inside applyMapperOnOrderBy method.");
        if (criteria == null || finalcriteria == null) {
            return;
        }
        List columnOrders = criteria.getOrderByFields();
        for (ColumnOrder columnOrder : columnOrders) {
            String mappedColumn = MapperUtility.getMappedValue(fieldMap, columnOrder.getColumnName());
            if (mappedColumn == null || mappedColumn.isEmpty()) continue;
            finalcriteria.addOrderByField(mappedColumn, columnOrder.isAscending());
        }
    }

    public static void applyMapperOnFilter(Criteria criteria, Criteria finalcriteria, Map<String, String> fieldMap) {
        LOGGER.debug((Object)"Inside applyMapperOnFilter method.");
        if (criteria == null || finalcriteria == null) {
            return;
        }
        List filters = criteria.getFilters();
        for (IFilter filter : filters) {
            IFilter mappedFilter = MapperUtility.prepareFilter(fieldMap, filter);
            if (mappedFilter == null) continue;
            finalcriteria.addFilter(mappedFilter);
        }
    }

    private static void expandHierarchy(TreeNode<String> finalTreeNode, TreeNode<String> treeNode, Map<String, List<TreeNode<String>>> srcTreeMap) throws DataAdapterConnectorException {
        List childList = treeNode.getChildren();
        for (TreeNode node : childList) {
            TreeNode<String> srcNode;
            TreeNode<String> treeNode2 = srcNode = srcTreeMap.get(node.getData()) == null ? null : srcTreeMap.get(node.getData()).get(0);
            if (srcNode != null) {
                TreeNode clonedNode = srcNode.deepClone();
                MapperUtility.expandHierarchy((TreeNode<String>)finalTreeNode.addChildNode(clonedNode), (TreeNode<String>)node, srcTreeMap);
                continue;
            }
            String errorCode = DataAdapterConnectorException.OBJECT_SOURCE_MAPPING_ERROR;
            String errorMessage = DataAdapterConnectorException.getErrorCodeMessage(errorCode);
            errorMessage = MessageFormat.format(errorMessage, node.getData());
            throw new DataAdapterConnectorException(errorCode, errorMessage);
        }
    }

    private static String getMappedValue(Map<String, String> mapper, String key) {
        return mapper.get(key);
    }

    private static IFilter prepareFilter(Map<String, String> mapper, IFilter filter) {
        if (filter == null) {
            return null;
        }
        Filter mappedFilter = null;
        if (filter instanceof Filter) {
            Filter origFilter = (Filter)filter;
            String filterKey = origFilter.getFilterKey();
            if ((filterKey = MapperUtility.getMappedValue(mapper, filterKey)) != null) {
                mappedFilter = new Filter(filterKey, origFilter.getFilterValue(), origFilter.getFilterType());
            }
        } else if (filter instanceof CompositeFilter) {
            CompositeFilter origFilter = (CompositeFilter)filter;
            IFilter[] childFilters = origFilter.getFilters();
            ArrayList<IFilter> mappedchildFilters = new ArrayList<IFilter>();
            for (IFilter filterEntry : childFilters) {
                IFilter childFilter = MapperUtility.prepareFilter(mapper, filterEntry);
                if (childFilter == null) continue;
                mappedchildFilters.add(childFilter);
            }
            if (mappedchildFilters.size() == 2) {
                mappedFilter = new CompositeFilter(origFilter.getOperator(), mappedchildFilters.toArray(new IFilter[2]));
            } else if (mappedchildFilters.size() == 1) {
                mappedFilter = (IFilter)mappedchildFilters.get(0);
            }
        }
        return mappedFilter;
    }

    public static Result applyMapperOnResult(DataControllerRequest dcr, Service service, Result result, DataAdapterEventNotifier notifier) throws MapperException {
        LOGGER.debug((Object)("Inside applyMapperOnResult method for service " + service.getId()));
        if (MapperUtility.isMapperInServiceOutPut(service) && result != null) {
            ResultNode resultInput = new ResultNode(result);
            Mapper mappingMetaData = service.getServiceMappings().getServiceMappingsOutput().getMapper();
            HashMap<String, NodeElement> map = new HashMap<String, NodeElement>();
            map.put("response_in", (NodeElement)resultInput);
            map.put("identity", (NodeElement)new IdentityNode(MiddlewareMBaasUtils.getGatewayFromDCR(dcr)));
            if (dcr.getAttribute("criteria") != null) {
                Criteria criteria = (Criteria)dcr.getAttribute("criteria");
                map.put("criteria", (NodeElement)new CriteriaNode(criteria));
            }
            MapperUtility.addQueryParams(dcr, map);
            MapperUtility.addRequestHeaders(dcr, map);
            MapperUtility.addSessionAttributes(dcr, map);
            AbstractNodeCreator nodeCreator = null;
            nodeCreator = dcr.getAttribute("RowNodeCreator") != null ? (RowNodeCreator)((Object)dcr.getAttribute("RowNodeCreator")) : new ResultNodeCreator();
            MapperEngine outputmapper = new MapperEngine(mappingMetaData, (NodeCreator)nodeCreator, TenantUtilities.getJavaScriptEngineFromRequest(dcr));
            MapperUtility.addFunctions(outputmapper, service);
            ServiceOutputNode consolidatedNode = new ServiceOutputNode(map);
            try {
                MapperUtility.createAndNotifyEvent(notifier, DataAdapterEventType.ResponseMapperInput, (NodeElement)consolidatedNode);
                ServiceOutputNode serviceOutputNode = (ServiceOutputNode)outputmapper.process((Node)consolidatedNode);
                ResultRow finalResult = null;
                NodeElement responseOutput = serviceOutputNode.getValue("response_out");
                if (responseOutput instanceof Row) {
                    finalResult = new ResultRow();
                    finalResult.setRow((Row)responseOutput);
                } else {
                    finalResult = ((ResultNode)responseOutput).getResult();
                }
                MapperUtility.createAndNotifyEvent(notifier, DataAdapterEventType.ResponseMapperOutput, (NodeElement)serviceOutputNode);
                MapperUtility.copyMWConstants(result, finalResult);
                MapperUtility.clearResult(result);
                return finalResult;
            }
            catch (MapperRuntimeException e) {
                throw new MapperException("Exception while applying mapper on request", (Throwable)e);
            }
        }
        return result;
    }

    private static void clearResult(Result result) {
        result.clearDatasets();
        result.clearParams();
        result.clearRecords();
    }

    private static void copyMWConstants(Result source, Result target) {
        String[] constants;
        if (source == null || target == null) {
            return;
        }
        for (String constant : constants = new String[]{"opstatus", "httpStatusCode", "results", "errmsg", "updatedRecords", "deletedRecords"}) {
            MapperUtility.setParamTarget(source, target, constant);
        }
    }

    private static void setParamTarget(Result source, Result target, String param) {
        Param paramValue = source.getParamByName(param);
        if (paramValue != null) {
            target.addParam(paramValue);
        }
    }

    private static void addQueryParams(DataControllerRequest dcr, Map<String, NodeElement> map) {
        Object attribute = dcr.getAttribute("queryparams");
        Map query = (Map)attribute;
        if (query != null) {
            map.put("queryparams", (NodeElement)new MapNode(query));
        }
    }

    private static void addRequestHeaders(DataControllerRequest dcr, Map<String, NodeElement> map) {
        Map requestHeaders = dcr.getHeaderMap();
        if (requestHeaders != null) {
            map.put("request_headers", (NodeElement)new MapNode(requestHeaders));
        }
    }

    private static void addFunctions(MapperEngine mapper, Service service) {
        Functions functions = MiddlewareUtils.getServiceMetadata(service).getFunctions();
        if (mapper != null && functions != null) {
            for (Function function : functions.getFunction()) {
                mapper.addMappingFunction(function.getName(), function);
            }
        }
    }

    static void addSessionAttributes(DataControllerRequest dcr, Map<String, NodeElement> map) {
        Session session = dcr.getSession();
        if (session != null) {
            map.put("session", (NodeElement)new SessionNode(session));
        }
    }

    public static Entity prepareEntity(Service service, DataControllerRequest dcr, DataAdapter dataAdapter, EntityMetadata entityMetaData, DataAdapterEventNotifier notifier) throws MapperException {
        if (MapperUtility.isMapperInServiceInput(service) && dcr != null) {
            JavaScriptEngineWrapper jsEngineWrapper;
            Map<String, NodeElement> requestMap = MapperUtility.getRequestMap(dcr);
            ServiceInputNodeCreator serviceInputNodeCreator = new ServiceInputNodeCreator(requestMap, new EntityNodeCreator(dataAdapter, entityMetaData));
            NodeElement nodeElement = MapperUtility.prepareRequestNode(service, (NodeCreator)serviceInputNodeCreator, requestMap, notifier, jsEngineWrapper = TenantUtilities.getJavaScriptEngineFromRequest(dcr));
            return nodeElement != null ? ((EntityNode)nodeElement).getEntity() : null;
        }
        return null;
    }

    public static ServiceData prepareServiceData(Service service, DataControllerRequest dcr, DataAdapterEventNotifier notifier) throws MapperException {
        if (MapperUtility.isMapperInServiceInput(service) && dcr != null) {
            JavaScriptEngineWrapper jsEngineWrapper;
            Map<String, NodeElement> requestMap = MapperUtility.getRequestMap(dcr);
            ServiceInputNodeCreator serviceInputNodeCreator = new ServiceInputNodeCreator(requestMap, new ServiceDataInputNodeCreator());
            NodeElement nodeElement = MapperUtility.prepareRequestNode(service, (NodeCreator)serviceInputNodeCreator, requestMap, notifier, jsEngineWrapper = TenantUtilities.getJavaScriptEngineFromRequest(dcr));
            return nodeElement != null ? ((ServiceDataNode)nodeElement).getServiceObject() : null;
        }
        return null;
    }

    public static boolean isMapperInServiceInput(Service service) {
        return service.getServiceMappings().getServiceMappingsInput() != null && service.getServiceMappings().getServiceMappingsInput().getMapper() != null;
    }

    public static boolean isMapperInServiceOutPut(Service service) {
        return service.getServiceMappings().getServiceMappingsOutput() != null && service.getServiceMappings().getServiceMappingsOutput().getMapper() != null;
    }

    public static Map<String, Object> prepareInputMap(Service service, DataControllerRequest dcr, DataAdapterEventNotifier notifier) throws MapperException {
        if (MapperUtility.isMapperInServiceInput(service) && dcr != null) {
            JavaScriptEngineWrapper jsEngineWrapper;
            Map<String, NodeElement> requestMap = MapperUtility.getRequestMap(dcr);
            ServiceInputNodeCreator serviceInputNodeCreator = new ServiceInputNodeCreator(requestMap, new ResultNodeCreator());
            NodeElement nodeElement = MapperUtility.prepareRequestNode(service, (NodeCreator)serviceInputNodeCreator, requestMap, notifier, jsEngineWrapper = TenantUtilities.getJavaScriptEngineFromRequest(dcr));
            return nodeElement != null ? ((MapNode)nodeElement).getInputMap() : null;
        }
        return null;
    }

    private static void createAndNotifyEvent(DataAdapterEventNotifier notifier, DataAdapterEventType eventType, NodeElement nodeElement) {
        if (notifier != null) {
            DataAdapterEvent event = new DataAdapterEvent(eventType);
            event.addEventDetails("Node", MapperUtility.createNodeEventDetail(nodeElement));
            notifier.notify(event);
        }
    }

    private static NodeElement prepareRequestNode(Service service, NodeCreator serviceInputNodeCreator, Map<String, NodeElement> map, DataAdapterEventNotifier notifier, JavaScriptEngineWrapper jsEngineWrapper) throws MapperException {
        Mapper mappingMetaData = service.getServiceMappings().getServiceMappingsInput().getMapper();
        MapperEngine inputMapper = new MapperEngine(mappingMetaData, serviceInputNodeCreator, jsEngineWrapper);
        MapperUtility.addFunctions(inputMapper, service);
        ServiceInputNode consolidatedNode = new ServiceInputNode(map);
        return MapperUtility.processMapperOnRequestNode(notifier, inputMapper, consolidatedNode);
    }

    private static Criteria getCriteriaFromOdataFilter(String odataFilter) throws DataAdapterException {
        return CriteriaBuilderFactory.create((String)odataFilter).getCriteria();
    }

    private static Map<String, NodeElement> getRequestMap(DataControllerRequest dcr) throws MapperException {
        HashMap<String, NodeElement> map = new HashMap<String, NodeElement>();
        Node dcrNode = DCRNodeFactory.getNode(dcr);
        map.put("request_in", (NodeElement)dcrNode);
        map.put("identity", (NodeElement)new IdentityNode(MiddlewareMBaasUtils.getGatewayFromDCR(dcr)));
        MapperUtility.addQueryParams(dcr, map);
        if (dcr.getAttribute("criteria") != null) {
            Criteria criteria = (Criteria)dcr.getAttribute("criteria");
            map.put("criteria", (NodeElement)new CriteriaNode(criteria));
        } else {
            MapperUtility.setCriteriaNodeFromODataFilter(map);
        }
        MapperUtility.addRequestHeaders(dcr, map);
        MapperUtility.addSessionAttributes(dcr, map);
        return map;
    }

    private static void setCriteriaNodeFromODataFilter(Map<String, NodeElement> map) throws MapperException {
        String filterValue;
        if (map.containsKey("queryparams") && StringUtils.isNotBlank((String)(filterValue = (String)((MapNode)map.get("queryparams")).getInputMap().get("$filter")))) {
            try {
                Criteria criteria = MapperUtility.getCriteriaFromOdataFilter("$filter=" + EncodeUtils.encode((String)filterValue));
                map.put("criteria", (NodeElement)new CriteriaNode(criteria));
            }
            catch (DataAdapterException e) {
                LOGGER.error((Object)"Exception while preparing criteria from odatafilter ", (Throwable)e);
            }
        }
    }

    private static NodeElement processMapperOnRequestNode(DataAdapterEventNotifier notifier, MapperEngine inputMapper, Node consolidatedNode) throws MapperException {
        try {
            MapperUtility.createAndNotifyEvent(notifier, DataAdapterEventType.RequestMapperInput, (NodeElement)consolidatedNode);
            ServiceInputNode serviceInputNode = (ServiceInputNode)inputMapper.process(consolidatedNode);
            MapperUtility.createAndNotifyEvent(notifier, DataAdapterEventType.RequestMapperOutput, (NodeElement)serviceInputNode);
            return serviceInputNode.getValue("request_out");
        }
        catch (MapperRuntimeException e) {
            throw new MapperException("Exception while applying mapper on result", (Throwable)e);
        }
    }

    public static EventDetail createNodeEventDetail(final NodeElement nodeElement) {
        return new EventDetail(){
            private static final long serialVersionUID = 1L;

            public JsonElement toJson() {
                return JsonMapperUtility.nodeElementToJsonElement((NodeElement)nodeElement);
            }
        };
    }

    public static String getType(Object object) {
        if (object instanceof Integer) {
            return "int";
        }
        if (object instanceof Double) {
            return "double";
        }
        if (object instanceof Number) {
            return "number";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        return "";
    }

    private MapperUtility() {
    }
}

