/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.common.MWConstants;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public final class MiddlewareIOUtils {
    private static final Logger LOGGER = Logger.getLogger(MiddlewareIOUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAllLines(String path) {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(path));
            string = MiddlewareIOUtils.readAllLines(in);
        }
        catch (FileNotFoundException e) {
            String string2;
            try {
                LOGGER.warn((Object)("File not found: " + path), (Throwable)e);
                string2 = "";
            }
            catch (Throwable throwable) {
                Closer.closeQuietly(in);
                throw throwable;
            }
            Closer.closeQuietly((Closeable)in);
            return string2;
        }
        Closer.closeQuietly((Closeable)in);
        return string;
    }

    public static String readAllLines(InputStream inputStream) {
        StringBuilder sb = new StringBuilder();
        if (inputStream != null) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = br.readLine()) != null) {
                    sb.append(line).append(MWConstants.LINE_SEPARATOR);
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Unable to read input stream", (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static String readFirstLine(InputStream inputStream) {
        if (inputStream != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                return br.readLine();
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Unable to read input stream", (Throwable)e);
            }
        }
        return "";
    }

    public static String makeDirIfNotexist(String dirPath) {
        boolean areDirsCreated;
        File dir = new File(dirPath);
        if (!dir.exists() && !(areDirsCreated = dir.mkdirs())) {
            LOGGER.error((Object)("FATAL ERROR OCCURRED. Unable to create folder " + dirPath + ". User operation is likely to fail."));
        }
        return dirPath;
    }

    public static byte[] getBytesQuitely(InputStream inputStream) {
        try {
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception while converting stream to bytes", (Throwable)e);
            return null;
        }
    }

    public static File getFileForFileNameAndExtension(String filePath, String extension) throws IOException {
        File file = new File(filePath + extension);
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    public static void extractZip(InputStream assetInputStream, String pathToExtract) throws IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(assetInputStream);
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            int len;
            String fileName = zipEntry.getName();
            File newFile = new File(pathToExtract + fileName);
            if (newFile.isDirectory()) {
                MiddlewareIOUtils.makeDirIfNotexist(newFile.toString());
            } else {
                new File(newFile.getParent()).mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(newFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    private MiddlewareIOUtils() {
    }
}

