/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.google.gson.JsonObject;
import com.kony.adapter.criteria.Criteria;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.util.criteria.CriteriaBuilder;
import com.kony.adapter.util.criteria.CriteriaBuilderFactory;
import com.kony.mobilefabric.cache.director.CacheDirector;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.api.OperationData;
import com.konylabs.middleware.api.ServicesManager;
import com.konylabs.middleware.api.ServicesManagerImpl;
import com.konylabs.middleware.classloader.ClassLoaderProperties;
import com.konylabs.middleware.classloader.MiddlewareClassloader;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.classloader.resources.ConfigurationProperties;
import com.konylabs.middleware.common.EncryptDecryptText;
import com.konylabs.middleware.common.KHttpServletRequestWrapper;
import com.konylabs.middleware.common.KHttpServletResponseWrapper;
import com.konylabs.middleware.common.MiddlewareValidationListener;
import com.konylabs.middleware.common.ServerProperties;
import com.konylabs.middleware.config.DevicePayloadLogger;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterConnector;
import com.konylabs.middleware.connectors.logservice.QueueService;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.dataobject.ResultToJSON;
import com.konylabs.middleware.datasourcelogs.DeviceResponseData;
import com.konylabs.middleware.datasourcelogs.DiagnosticLogService;
import com.konylabs.middleware.environment.Environment;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.environment.impl.AmazonMobileFabricEnvironment;
import com.konylabs.middleware.environment.impl.DefaultEnvironment;
import com.konylabs.middleware.environment.impl.OnPremiseMobileFabricEnvironment;
import com.konylabs.middleware.metrics.MetricsBean;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Dataset;
import com.konylabs.middleware.registry.vo.Header;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.DigestUtil;
import com.konylabs.middleware.utilities.EncodeUtils;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MetricsBeanUtils;
import com.konylabs.middleware.utilities.RequestUtils;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MiddlewareUtils {
    private static final Logger LOGGER = Logger.getLogger(MiddlewareUtils.class);
    private static final String DID_PATTERN = "(#foreach[\\s]\\$(.*?)[\\s|<])";
    private static final Pattern PATTERN = Pattern.compile("(#foreach[\\s]\\$(.*?)[\\s|<])");
    private static final Pattern DIR_BLACKLIST_PAT = Pattern.compile("([*?<>|])");
    private static final Pattern PERCENTS_PAT = Pattern.compile("(%)([0-9a-fA-F])([0-9a-fA-F])");
    private static final Pattern FILE_BLACKLIST_PAT = Pattern.compile("([\\\\/:*?<>|])");
    private static final String MW_SUCCESS_RESPONSE_CODE = "0";

    public static String maskResponse(String response) {
        if (!MiddlewareValidationListener.getResponseElementMaskList().isEmpty()) {
            for (String element : MiddlewareValidationListener.getResponseElementMaskList()) {
                response = MiddlewareUtils.maskXMLElement(response, element);
            }
        }
        return response;
    }

    public static String maskXMLElement(String response, String element) {
        String startElement = "<([^:]+:)?" + element + ">";
        String endElement = "</([^:]+:)?" + element + ">";
        String regex = startElement + "([^<]*)" + endElement;
        String replaceString = "<$1" + element + ">" + "****" + "</$3" + element + ">";
        return response.replaceAll(regex, replaceString);
    }

    public static String maskJSONResponse(Object jsonObject) throws JSONException {
        StringBuilder jsonRes = new StringBuilder();
        if (jsonObject instanceof JSONObject) {
            MiddlewareUtils.maskJSON((JSONObject)jsonObject, jsonRes);
        } else if (jsonObject instanceof JSONArray) {
            MiddlewareUtils.maskJSON((JSONArray)jsonObject, jsonRes);
        }
        return jsonRes.toString();
    }

    private static void maskJSON(JSONObject jsonDocument, StringBuilder json) throws JSONException {
        json.append("{");
        Iterator jsonItr = jsonDocument.keys();
        while (jsonItr.hasNext()) {
            Object child = jsonItr.next();
            if (MiddlewareValidationListener.getResponseElementMaskList().contains(child)) {
                json.append(child + ":*******");
            } else {
                json.append(child + ":" + jsonDocument.get(child.toString()));
            }
            json.append(jsonItr.hasNext() ? "," : "");
        }
        json.append("}");
    }

    private static void maskJSON(JSONArray jsonDocument, StringBuilder json) throws JSONException {
        json.append("[");
        for (int i = 0; i < jsonDocument.length(); ++i) {
            if (jsonDocument.get(i) instanceof JSONObject) {
                MiddlewareUtils.maskJSON(jsonDocument.getJSONObject(i), json);
                continue;
            }
            if (jsonDocument.get(i) instanceof JSONArray) {
                MiddlewareUtils.maskJSON(jsonDocument.getJSONArray(i), json);
                continue;
            }
            json.append(jsonDocument.get(i).toString());
        }
        json.append("]");
    }

    public static void maskTrace(String errorCode, String errorStr, Exception e) {
        String ndcDelimiter = ConfigUtility.getProperty((String)"ndc.delimiter", (String)"\n");
        MaskUtils.maskTrace((String)(ndcDelimiter + errorCode + ndcDelimiter + " " + errorStr), (Throwable)e);
    }

    public static boolean isSecureParamsPresent(Service service) {
        ArrayList datasets;
        boolean present = false;
        ArrayList params = service.getServiceOutput().getParams();
        if (params != null) {
            for (int idx = 0; idx < params.size(); ++idx) {
                Param param = (Param)params.get(idx);
                if (!MiddlewareValidationListener.getKeyList().contains(param.getName())) continue;
                present = true;
                break;
            }
        }
        if (!present && (datasets = service.getServiceOutput().getDatasets()) != null) {
            block1: for (int idx = 0; idx < datasets.size(); ++idx) {
                Dataset dataset = (Dataset)datasets.get(idx);
                if (MiddlewareValidationListener.getKeyList().contains(dataset.getId())) {
                    present = true;
                    break;
                }
                ArrayList paramList = dataset.getParams();
                for (int idy = 0; idy < paramList.size(); ++idy) {
                    Param param = (Param)paramList.get(idy);
                    if (!MiddlewareValidationListener.getKeyList().contains(param.getName())) continue;
                    present = true;
                    continue block1;
                }
            }
        }
        return present;
    }

    public static com.konylabs.middleware.dataobject.Dataset convertJSON2Dataset(String jsonString, String id) {
        com.konylabs.middleware.dataobject.Dataset dataset = new com.konylabs.middleware.dataobject.Dataset();
        dataset.setId(id);
        if (jsonString == null || jsonString.length() == 0) {
            return dataset;
        }
        try {
            if (jsonString.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(jsonString);
                Iterator itr = jsonObject.keys();
                if (itr.hasNext()) {
                    String key = (String)itr.next();
                    dataset.setId(key);
                    JSONArray jsonArray = (JSONArray)jsonObject.get(key);
                    MiddlewareUtils.convertJSONArray2Dataset(jsonArray, dataset);
                }
            } else if (jsonString.startsWith("[")) {
                MiddlewareUtils.convertJSONArray2Dataset(new JSONArray(jsonString), dataset);
            } else {
                LOGGER.error((Object)"JSON string is not starting with { or [");
            }
        }
        catch (JSONException jExe) {
            LOGGER.error((Object)"JSON to Dataset conversion exception", (Throwable)jExe);
        }
        return dataset;
    }

    private static void convertJSONArray2Dataset(JSONArray jsonArray, com.konylabs.middleware.dataobject.Dataset dataset) throws JSONException {
        if (jsonArray != null) {
            for (int idx = 0; idx < jsonArray.length(); ++idx) {
                JSONObject jsonObj = (JSONObject)jsonArray.get(idx);
                Record record = new Record();
                Iterator it = jsonObj.keys();
                while (it.hasNext()) {
                    String chKey = (String)it.next();
                    Object obj = jsonObj.get(chKey);
                    if (obj instanceof JSONArray) {
                        com.konylabs.middleware.dataobject.Dataset dset = new com.konylabs.middleware.dataobject.Dataset();
                        dset.setId(chKey);
                        Record rec = new Record();
                        for (int i = 0; i < ((JSONArray)obj).length(); ++i) {
                            rec = new Record();
                            JSONObject jsonOb = (JSONObject)((JSONArray)obj).get(i);
                            Iterator j = jsonOb.keys();
                            while (j.hasNext()) {
                                String chhKey = (String)j.next();
                                Object innerObj = jsonOb.get(chhKey);
                                if (innerObj instanceof JSONArray) {
                                    com.konylabs.middleware.dataobject.Dataset innerDataset = new com.konylabs.middleware.dataobject.Dataset();
                                    innerDataset.setId(chhKey);
                                    MiddlewareUtils.convertJSONArray2Dataset((JSONArray)innerObj, innerDataset);
                                    rec.addDataset(innerDataset);
                                    continue;
                                }
                                com.konylabs.middleware.dataobject.Param p = new com.konylabs.middleware.dataobject.Param();
                                p.setName(chhKey);
                                if (!jsonOb.isNull(chhKey)) {
                                    p.setValue(jsonOb.get(chhKey).toString());
                                } else {
                                    p.setValue("");
                                }
                                MaskUtils.logDebugWithMasking((String)"JSON key", (String)p.getName(), (String)p.getValue());
                                rec.addParam(p);
                            }
                            if (rec.getAllParams().size() <= 0 && rec.getAllDatasets().size() <= 0) continue;
                            dset.addRecord(rec);
                        }
                        record.addDataset(dset);
                        continue;
                    }
                    com.konylabs.middleware.dataobject.Param param = new com.konylabs.middleware.dataobject.Param();
                    param.setName(chKey);
                    if (!jsonObj.isNull(chKey)) {
                        param.setValue(jsonObj.get(chKey).toString());
                    } else {
                        param.setValue("");
                    }
                    record.addParam(param);
                }
                dataset.addRecord(record);
            }
        }
    }

    public static String replaceMissingDatasets(String tvalue) {
        Matcher matcher = PATTERN.matcher(tvalue);
        if (matcher.find()) {
            LOGGER.debug((Object)("got :" + matcher.group() + "|"));
            String did = matcher.group(2);
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            StringBuffer str = new StringBuffer("($rec in $").append(did).append(".records) ");
            tvalue = tvalue.substring(0, startIndex) + "#foreach " + str.toString() + tvalue.substring(endIndex);
            return MiddlewareUtils.replaceMissingDatasets(tvalue);
        }
        return tvalue;
    }

    public static String getContentType(Map<?, ?> configMap, String defaultContentType) {
        String contentType = null;
        contentType = configMap != null && configMap.get("content-type") != null && ((String)configMap.get("content-type")).length() > 0 ? (String)configMap.get("content-type") : (configMap != null && !configMap.isEmpty() && configMap.get("Content-Type") != null && ((String)configMap.get("Content-Type")).length() > 0 ? (String)configMap.get("Content-Type") : defaultContentType);
        LOGGER.debug((Object)("returning content-type = " + contentType));
        return contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDuration(DataControllerRequest request, long duration, String attribute) {
        HttpServletRequest originalRequest = (HttpServletRequest)request.getOriginalRequest();
        if (null != originalRequest) {
            HttpServletRequest httpServletRequest = originalRequest;
            synchronized (httpServletRequest) {
                originalRequest.setAttribute(attribute, (Object)duration);
            }
        } else {
            request.setAttribute(attribute, (Object)duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAttributeToRequest(DataControllerRequest request, String value, String attribute) {
        HttpServletRequest originalRequest = (HttpServletRequest)request.getOriginalRequest();
        if (null != originalRequest) {
            HttpServletRequest httpServletRequest = originalRequest;
            synchronized (httpServletRequest) {
                originalRequest.setAttribute(attribute, (Object)value);
            }
        } else {
            request.setAttribute(attribute, (Object)value);
        }
    }

    public static boolean isAmazonS3Support() {
        return EnvironmentFactory.getEnvironment() instanceof AmazonMobileFabricEnvironment;
    }

    public static boolean isOnPremMobileFabEnvironment() {
        boolean isOnPremMobileFabEnvironment = EnvironmentFactory.getEnvironment() instanceof OnPremiseMobileFabricEnvironment;
        if (isOnPremMobileFabEnvironment) {
            LOGGER.debug((Object)"isOnPremMobileFabEnvironment is set to true");
        }
        return isOnPremMobileFabEnvironment;
    }

    public static boolean isDefaultEnvironment() {
        return EnvironmentFactory.getEnvironment() instanceof DefaultEnvironment;
    }

    public static String getResponseJsonString(String opstatus, int httpStatusCode, String msg) throws JSONException {
        Result result = new Result();
        result.addParam(MiddlewareUtils.getParam("opstatus", String.valueOf(opstatus), "int"));
        result.addParam(MiddlewareUtils.getParam("httpStatusCode", String.valueOf(httpStatusCode), "int"));
        if (opstatus.equals(MW_SUCCESS_RESPONSE_CODE)) {
            result.addParam(MiddlewareUtils.getParam("errmsg", msg, "string"));
        } else {
            result.addParam(MiddlewareUtils.getParam("msg", msg, "string"));
        }
        return ResultToJSON.convert((Result)result);
    }

    private static com.konylabs.middleware.dataobject.Param getParam(String name, String value, String type) {
        return new com.konylabs.middleware.dataobject.Param(name, value, type);
    }

    public static String prepareDestKey(Map<Object, Object> props) {
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(props);
        return DigestUtil.digest(((Object)treeMap).toString());
    }

    public static String getRequestId(HttpServletRequest req) {
        return RequestUtils.getRequestId((HttpServletRequest)req);
    }

    public static String replaceHostNameInURL(String srcURL, String destHostName) {
        String newURL = null;
        int protocolIndex = srcURL.indexOf("//") + 2;
        int resourceIndex = srcURL.indexOf(47, protocolIndex);
        String resources = srcURL.substring(resourceIndex);
        newURL = destHostName + resources;
        return newURL;
    }

    public static Map<String, Object> populateConfigMap(Service service) {
        return MiddlewareUtils.populateConfigMap(service, MiddlewareUtils.getServiceMetadata(service));
    }

    public static Map<String, Object> populateConfigMap(Service service, ServiceMetadata serviceMetadata) {
        Map<String, Object> configMap = null;
        try {
            if (service != null) {
                Map<String, ConfigParam> appConfigParams = null;
                if (serviceMetadata != null) {
                    configMap = serviceMetadata.getServiceConfigParamMap();
                    appConfigParams = serviceMetadata.getAppConfigParams();
                } else {
                    configMap = new HashMap<String, Object>();
                }
                boolean serviceInputPassThru = MiddlewareUtils.isRequestPassThrough(service);
                boolean serviceOutputPassThru = MiddlewareUtils.isResponsePassThrough(service);
                configMap.put("isReqPassThru", String.valueOf(serviceInputPassThru));
                configMap.put("isResPassThru", String.valueOf(serviceOutputPassThru));
                boolean passEncrypted = StringUtils.isNotBlank((String)service.getPasswordEncrypted()) ? Boolean.parseBoolean(service.getPasswordEncrypted()) : true;
                ArrayList serviceConfigParams = service.getServiceConfig().getServiceConfig();
                if (serviceConfigParams != null && !serviceConfigParams.isEmpty()) {
                    Iterator itr = serviceConfigParams.iterator();
                    while (itr.hasNext()) {
                        MiddlewareUtils.prepareConfigMap(configMap, passEncrypted, (ConfigParam)itr.next());
                    }
                }
                if (appConfigParams != null && !appConfigParams.isEmpty()) {
                    Set<Map.Entry<String, ConfigParam>> configParamSet = appConfigParams.entrySet();
                    for (Map.Entry<String, ConfigParam> configParamMap : configParamSet) {
                        ConfigParam param = configParamMap.getValue();
                        if (configMap.containsKey(param.getName()) && configMap.get(param.getName()) == null) continue;
                        MiddlewareUtils.prepareConfigMap(configMap, passEncrypted, param);
                    }
                }
            }
        }
        catch (Exception e) {
            MaskUtils.maskTrace((String)e.getMessage(), (Throwable)e);
        }
        return configMap;
    }

    private static void prepareConfigMap(Map<String, Object> configMap, boolean passEncrypted, ConfigParam param) {
        if (param != null) {
            String value = param.getValue();
            if (passEncrypted && (param.getName().equals("pwd") || param.getName().equals("proxypwd") || param.getName().equals("password") || param.getName().equals("proxypassword"))) {
                value = EncryptDecryptText.decryptTextLegacy((String)value);
            }
            configMap.put(param.getName(), value);
        }
    }

    public static void populateAdditionalConfig(ServiceMetadata serviceMetadata, DataControllerRequest request, Map<String, Object> configMap) {
        Session session;
        String appId = serviceMetadata.getAppId();
        String serviceId = serviceMetadata.getService().getId();
        configMap.put("appID", appId);
        String apiVersion = serviceMetadata.getVersion();
        if (StringUtils.isBlank((String)apiVersion)) {
            apiVersion = MiddlewareUtils.getRuntimeVersion(serviceMetadata.getAppMetadata().getAppCache(), appId);
        }
        configMap.put("X-Kony-API-Version", apiVersion);
        configMap.put("serviceID", serviceId);
        LOGGER.debug((Object)("REQUEST_ID " + request.getAttribute("requestID")));
        Object requestId = request.getAttribute("requestID");
        if (requestId == null && request.getOriginalRequest() != null) {
            requestId = ((ServletRequest)request.getOriginalRequest()).getAttribute("requestID");
        }
        LOGGER.debug((Object)("REQUEST_ID " + requestId));
        configMap.put("requestID", requestId);
        configMap.put("channel", request.getParameter("channel"));
        String useragent = request.getHeader("user-agent");
        LOGGER.debug((Object)("USER_AGENT " + useragent));
        if (useragent != null) {
            configMap.put("useragent", useragent);
        }
        if ((session = request.getSession(false)) != null) {
            String dHeight;
            String dWidth;
            LOGGER.debug((Object)("SESSION_ID " + session.getId()));
            configMap.put("SESSIONID", session.getId());
            Integer deviceID = (Integer)session.getAttribute("deviceID");
            if (deviceID != null) {
                configMap.put("deviceID", session.getAttribute("deviceID"));
            }
            if ((dWidth = (String)session.getAttribute("deviceWidth")) != null) {
                configMap.put("deviceWidth", dWidth);
            }
            if ((dHeight = (String)session.getAttribute("deviceHeight")) != null) {
                configMap.put("deviceHeight", dHeight);
            }
            LOGGER.debug((Object)("DEVICE_ID " + deviceID));
            LOGGER.debug((Object)("DEVICE_WIDTH " + dWidth));
            LOGGER.debug((Object)("DEVICE_HEIGHT " + dHeight));
        }
    }

    public static boolean isRequestPassThrough(Service service) {
        if (service != null && service.getServiceInput() != null) {
            return service.getServiceInput().isPassthrough() || "APIProxyConnector".equalsIgnoreCase(service.getServiceType());
        }
        return false;
    }

    public static boolean isResponsePassThrough(Service service) {
        if (service != null && service.getServiceOutput() != null) {
            return service.getServiceOutput().isPassthrough() || "APIProxyConnector".equalsIgnoreCase(service.getServiceType());
        }
        return false;
    }

    public static boolean isHeadersPassThrough(Service service) {
        if (service != null) {
            Header header;
            ArrayList hParams;
            if ("APIProxyConnector".equalsIgnoreCase(service.getServiceType())) {
                return true;
            }
            if (service.getServiceInput() != null && !(hParams = service.getServiceInput().getHeaders()).isEmpty() && (header = (Header)hParams.get(0)).isPassthrough()) {
                return header.isPassthrough();
            }
        }
        return false;
    }

    public static String getRuntimeVersion(AppCache appCache, String appId) {
        String availableHigherVersion;
        String string = availableHigherVersion = appCache != null ? appCache.getRuntimeVersion(appId) : null;
        if (StringUtils.isBlank((String)availableHigherVersion)) {
            return "1.0";
        }
        return availableHigherVersion;
    }

    public static String getApplicationAvailableHigherVersion(AppCache appCache, String appId) {
        return StringUtils.isNotBlank((String)appId) && appCache != null ? appCache.getServiceVersionCache().getHighestVersion(appId) : null;
    }

    private static Service getService(AppVersion appVersion, String serviceId, AppCache appCache) throws AppRegistryException {
        ApplicationMetadata appMeta = (ApplicationMetadata)appCache.getAppMetadata(appVersion);
        Service serviceObj = null;
        if (appMeta == null) {
            String errorCode = "10101";
            String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            LOGGER.error((Object)errorMessage);
            throw new AppRegistryException(errorCode, errorMessage);
        }
        if (appMeta != null) {
            serviceObj = MiddlewareUtils.getService(appMeta, serviceId);
        }
        if (serviceObj == null) {
            String errorCode = "10102";
            String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            errorMessage = MessageFormat.format(errorMessage, serviceId);
            LOGGER.error((Object)errorMessage);
            throw new AppRegistryException(errorCode, errorMessage);
        }
        return serviceObj;
    }

    private static Service getService(ApplicationMetadata applicationMetadata, String serviceId) {
        return applicationMetadata.getServiceMetadata(serviceId).getService();
    }

    public static ServiceMetadata getServiceMetadata(Service service) {
        return (ServiceMetadata)service.getCustomObjMap().get("serviceMetadataKey");
    }

    public static Service getIntegrationServiceFromSDO(String appId, String serviceId, String apiVersion, Service service) throws AppRegistryException {
        ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(service);
        ConfigParam configParam = service.getServiceConfig().getConfigParam("service");
        String configValue = configParam.getValue();
        String[] tokens = configValue.split("\\.");
        if (tokens.length == 1) {
            appId = serviceMetadata.getAppId();
            serviceId = tokens[0];
        } else {
            appId = tokens[0];
            serviceId = tokens[1];
        }
        apiVersion = configParam.getApiVersion() != null ? configParam.getApiVersion() : MiddlewareUtils.getRuntimeVersion(serviceMetadata.getAppMetadata().getAppCache(), appId);
        AppVersion appVersion = new AppVersion(appId, apiVersion);
        return MiddlewareUtils.getService(appVersion, serviceId, serviceMetadata.getAppMetadata().getAppCache());
    }

    public static Criteria prepareCriteria(Criteria criteria, HashMap<String, String> inputMap) throws DataAdapterException {
        if (criteria == null) {
            criteria = new Criteria();
        }
        StringBuilder sbCriteria = new StringBuilder();
        LOGGER.debug((Object)"prepareCriteria()");
        if (inputMap != null) {
            for (String key : inputMap.keySet()) {
                if (!key.startsWith("$") || inputMap.get(key) == null) continue;
                if (sbCriteria.length() > 0) {
                    sbCriteria.append("&");
                }
                String value = inputMap.get(key);
                String encodedValue = EncodeUtils.encode((String)value);
                sbCriteria.append(key).append("=").append(encodedValue);
            }
        }
        CriteriaBuilder criteriaBuilder = CriteriaBuilderFactory.create((String)sbCriteria.toString());
        return criteriaBuilder.getCriteria();
    }

    public static boolean isFilePathValid(String filePath) {
        LOGGER.debug((Object)("Validating file path - " + filePath));
        Matcher m = FILE_BLACKLIST_PAT.matcher(filePath);
        if (m.find()) {
            LOGGER.debug((Object)("Invalid directory - contains illegal character: " + m.group()));
            return false;
        }
        if (filePath.contains("../") || filePath.contains("..\\")) {
            return false;
        }
        Matcher m1 = PERCENTS_PAT.matcher(filePath);
        if (m1.find()) {
            return false;
        }
        int ch = MiddlewareUtils.hasInvalidChars(filePath);
        if (ch != -1) {
            LOGGER.debug((Object)("Invalid file path - contains unprintable character: " + ch));
            return false;
        }
        return true;
    }

    public static boolean isDirPathValid(String filePath) {
        LOGGER.debug((Object)("Validating directory path - " + filePath));
        Matcher m = DIR_BLACKLIST_PAT.matcher(filePath);
        if (m.find()) {
            LOGGER.debug((Object)("Invalid directory - contains illegal character: " + m.group()));
            return false;
        }
        if (filePath.contains("../") || filePath.contains("..\\")) {
            return false;
        }
        Matcher m1 = PERCENTS_PAT.matcher(filePath);
        if (m1.find()) {
            return false;
        }
        int ch = MiddlewareUtils.hasInvalidChars(filePath);
        if (ch != -1) {
            LOGGER.debug((Object)("Invalid file path - contains unprintable character: " + ch));
            return false;
        }
        return true;
    }

    private static int hasInvalidChars(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= ' ' && ch <= '~') continue;
            return ch;
        }
        return -1;
    }

    public static boolean isValidServiceName(String appId) {
        return appId.matches("[a-zA-Z]{1}[a-zA-Z0-9_-]{3,29}");
    }

    public static boolean isBinaryOperand(Map<String, Object> config) {
        if (config != null) {
            String opCode = (String)config.get("opcode");
            return DataAdapterConnector.OPCODE.queryBinary.toString().equals(opCode) || DataAdapterConnector.OPCODE.createBinary.toString().equals(opCode) || DataAdapterConnector.OPCODE.updateBinary.toString().equals(opCode) || DataAdapterConnector.OPCODE.deleteBinary.toString().equals(opCode);
        }
        return false;
    }

    public static Map<String, Object> convertToLowerCaseMap(Map<String, Object> map) {
        HashMap<String, Object> lowerCaseHeaderMap = MiddlewareUtils.createCaseInsensitiveMap();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                lowerCaseHeaderMap.put(entry.getKey(), entry.getValue());
            }
        }
        return lowerCaseHeaderMap;
    }

    private static <T> HashMap<String, T> createCaseInsensitiveMap() {
        return new HashMap<String, T>(){

            @Override
            public T get(Object key) {
                return super.get(key == null ? null : key.toString().toLowerCase());
            }

            @Override
            public T put(String key, T value) {
                return super.put(key == null ? null : key.toLowerCase(), value);
            }
        };
    }

    public static String getTenantIDFromURL(String environmentUrl) {
        if (environmentUrl != null) {
            try {
                return new URI(environmentUrl).getHost().split("\\.")[0];
            }
            catch (URISyntaxException e) {
                LOGGER.error((Object)"Unable to parse the Envieonment URL");
            }
        }
        return null;
    }

    public static Set<String> splitAndRemoveBlank(String propertyName, String separator) {
        LOGGER.info((Object)("Looking up for property : " + propertyName));
        String propertyValue = ConfigUtility.getProperty((String)propertyName, (String)"");
        HashSet<String> splittedValues = new HashSet<String>();
        if (StringUtils.isBlank((String)propertyValue)) {
            LOGGER.info((Object)("Unable to find the property " + propertyName));
        } else {
            LOGGER.info((Object)("Successfully found property " + propertyName + " with value " + propertyValue));
            String[] propertyValues = propertyValue.split(separator);
            if (propertyValues != null) {
                for (int i = 0; i < propertyValues.length; ++i) {
                    if (!StringUtils.isNotBlank((String)propertyValues[i])) continue;
                    splittedValues.add(propertyValues[i]);
                }
            }
        }
        return splittedValues;
    }

    public static KHttpServletRequestWrapper getKHttpServletRequestWrapper(HttpServletRequest req, boolean isRequestPassthrough) {
        return req instanceof KHttpServletRequestWrapper ? (KHttpServletRequestWrapper)req : new KHttpServletRequestWrapper(req, isRequestPassthrough);
    }

    public static KHttpServletResponseWrapper getKHttpServletResponseWrapper(HttpServletResponse response) {
        return response instanceof KHttpServletResponseWrapper ? (KHttpServletResponseWrapper)response : new KHttpServletResponseWrapper(response);
    }

    public static String getFormattedDateString(Date value) {
        Date date = new Date(value.getTime());
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 ? new SimpleDateFormat("yyyy-MM-dd").format(date) : DatatypeConverter.printDateTime((Calendar)cal);
    }

    public static String getDeviceID(HttpServletRequest httpServletRequest, boolean isRequestPassthrough) {
        try {
            String deviceId = httpServletRequest.getHeader("X-Kony-DeviceId");
            if (StringUtils.isNotBlank((String)deviceId)) {
                return deviceId;
            }
            String xkonyReportingParams = MiddlewareUtils.getReportingParams(httpServletRequest, isRequestPassthrough);
            if (StringUtils.isNotBlank((String)xkonyReportingParams)) {
                return new JSONObject(xkonyReportingParams).getString("did");
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception while parsing device id, name:-" + ex.getMessage()));
        }
        return null;
    }

    public static String getReportingParams(HttpServletRequest httpServletRequest, boolean isRequestPassthrough) {
        if (httpServletRequest.getAttribute("konyreportingparams") != null) {
            return (String)httpServletRequest.getAttribute("konyreportingparams");
        }
        if (httpServletRequest.getHeader("X-Kony-ReportingParams") != null) {
            return EncodeUtils.decode((String)httpServletRequest.getHeader("X-Kony-ReportingParams"));
        }
        if (!isRequestPassthrough) {
            return httpServletRequest.getParameter("konyreportingparams");
        }
        return null;
    }

    public static String getHeadersAsString(HttpServletRequest requestWrapper) {
        StringBuilder builder = new StringBuilder();
        Enumeration headerNamesEnum = requestWrapper.getHeaderNames();
        if (headerNamesEnum != null) {
            ArrayList<String> headerList = Collections.list(headerNamesEnum);
            for (String headerName : headerList) {
                String headerValue = requestWrapper.getHeader(headerName);
                headerValue = MaskUtils.maskParamValue((String)headerName, (String)headerValue);
                builder.append(headerName).append(": ").append(headerValue).append('\n');
            }
        }
        return builder.toString();
    }

    public static String sanitizeFolderName(String folderName) {
        return folderName.replaceAll("[/,\\\\,.]", "_");
    }

    public static Map<String, String> getDefaltHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Pragma", "no-cache");
        headers.put("Cache-Control", "no-store, no-cache, must-revalidate");
        headers.put("Content-Type", "text/plain");
        return headers;
    }

    public static boolean isWebApp() {
        return ConfigUtility.getBoolean((String)"IS_WEB_APP", (boolean)false);
    }

    public static boolean doesJobsQueueExist() {
        Environment env = EnvironmentFactory.getEnvironment();
        QueueService queueService = null;
        boolean doesQueueExists = MiddlewareUtils.isAmazonS3Support() && (queueService = env.getQueueService()) != null && queueService.isJobsNotificationQueueConfigured();
        LOGGER.debug((Object)("Job Notification Queue exists in current environment: " + doesQueueExists));
        return doesQueueExists;
    }

    public static String getFormattedStringFromHeadersMap(Map<String, String> headers) {
        StringBuilder builder = new StringBuilder();
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                String headerValue = MaskUtils.maskParamValue((String)header.getKey(), (String)header.getValue());
                builder.append(header.getKey()).append(": ").append(headerValue).append('\n');
            }
        }
        return builder.toString();
    }

    public static AppVersion getAppVersionFromService(Service service) {
        ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(service);
        if (serviceMetadata != null) {
            ApplicationMetadata appMetadata = serviceMetadata.getAppMetadata();
            return appMetadata != null ? appMetadata.getApplicationVersion() : null;
        }
        return null;
    }

    public static String getJarModuleNameFromService(Service service) {
        ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(service);
        String defaultJarModuleName = ClassLoaderProperties.DEFAULT_MODULE_NAME.getName();
        if (serviceMetadata != null && serviceMetadata.getAppMetadata() != null && StringUtils.isNotBlank((String)serviceMetadata.getAppMetadata().getJarModuleName())) {
            defaultJarModuleName = serviceMetadata.getAppMetadata().getJarModuleName();
        }
        LOGGER.debug((Object)String.format("Associated jar module for the service [%s] is : [%s]", service.getId(), defaultJarModuleName));
        return defaultJarModuleName;
    }

    public static String getJarModuleName(Row clientData) {
        String jarModule = clientData.getMetadata().getObjectMetadata().getAppMetadata().getJarModuleName();
        if (StringUtils.isBlank((String)jarModule)) {
            jarModule = ClassLoaderProperties.DEFAULT_MODULE_NAME.getName();
        }
        LOGGER.debug((Object)String.format("Associated jar module for the object [%s] is : [%s]", clientData.getMetadata().getObjectName(), jarModule));
        return jarModule;
    }

    public static void updateCurrentServiceData(DataControllerRequest request, String appId, String apiVersion, String serviceId) {
        request.addRequestParam_("current_appID", appId);
        request.addRequestParam_("curent_apiVersion", apiVersion);
        request.addRequestParam_("current_serviceID", serviceId);
    }

    public static void logDeviceResponse(ServletRequest request, Object result, boolean isaddMetricParam) {
        if (result instanceof BufferedHttpEntity || result instanceof InputStream) {
            LOGGER.debug((Object)"Skipped logging device response.");
            return;
        }
        DevicePayloadLogger.log("Device Payload Response Body : %s", result);
        DeviceResponseData deviceResponseData = (DeviceResponseData)request.getAttribute("DeviceResLogBean");
        if (deviceResponseData != null) {
            JsonObject resultJson = DiagnosticLogService.convertToJSONQuietly(result);
            if (isaddMetricParam && resultJson != null) {
                MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)((HttpServletRequest)request), (String)"mw_response_context_data", (Object)resultJson.toString());
            }
            deviceResponseData.setBody(resultJson);
            DiagnosticLogService.logDeviceResponseData((DeviceResponseData)request.getAttribute("DeviceResLogBean"));
        }
    }

    public static boolean isServicesWar() {
        return ConfigUtility.getProperty((String)"KONY_SERVER_SERVICES_CONTEXT_PATH", (String)"services").equalsIgnoreCase(StringUtils.stripStart((String)ConfigUtility.getProperty((String)"context-path", null), (String)"/"));
    }

    public static String getRequestedVersion(HttpServletRequest httpServletRequest, AppCache appCache, String appId) {
        String version = httpServletRequest.getHeader("X-Kony-API-Version");
        if (StringUtils.isEmpty((String)version)) {
            version = (String)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"X-Kony-API-Version");
        }
        return StringUtils.isNotBlank((String)version) ? version : MiddlewareUtils.getRuntimeVersion(appCache, appId);
    }

    public static ServicesManager createServicesManager(TenantBean<AppCache> tenantBean, OperationData operationData, MetricsBean metricsBean, CacheDirector cacheDirector) {
        LOGGER.debug((Object)"Creating services manager.");
        MiddlewareClassloader loader = (MiddlewareClassloader)MiddlewareClassloaderFactory.getClassLoaderManager().getMiddlewareLibClassLoader();
        ConfigurationProperties configurationPropertiesBean = null;
        if (loader != null) {
            configurationPropertiesBean = loader.getResource(ConfigurationProperties.class);
        }
        return new ServicesManagerImpl(tenantBean, operationData, metricsBean, configurationPropertiesBean, cacheDirector);
    }

    public static String getContentType() {
        return (Boolean)ServerProperties.IS_RESPONSE_CONTENT_TYPE_PLAIN_TEXT.getFromConfig() != false ? "text/plain" : "application/json";
    }

    public static void removeContentTypeHeaderForGetIfRequested(HttpUriRequest request, DataControllerRequest dcRequest) {
        try {
            boolean removeHeader = Boolean.parseBoolean(dcRequest.getServicesManager().getConfigurableParametersHelper().getServerProperty("KONY_SERVER_REMOVE_CONTENT_HEADER_IN_GET"));
            if (removeHeader && "GET".equalsIgnoreCase(request.getMethod())) {
                request.removeHeaders("Content-Type");
            }
        }
        catch (AppRegistryException e) {
            LOGGER.error((Object)"Error while fetching server parameters", (Throwable)e);
        }
    }

    private MiddlewareUtils() {
    }
}

