/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.kony.mobilefabric.util.ReflectionUtils;
import com.konylabs.middleware.connectors.APIProxyConnector;
import com.konylabs.middleware.connectors.CompositeConnector;
import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.connectors.JavaConnector;
import com.konylabs.middleware.connectors.JavaConnector2;
import com.konylabs.middleware.connectors.JavaScriptConnector;
import com.konylabs.middleware.connectors.LoopingConnector;
import com.konylabs.middleware.connectors.ScraperConnector;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterConnector;
import com.konylabs.middleware.connectors.dataadapter.StorageConnector;
import com.konylabs.middleware.connectors.jms.JmsConnector;
import com.konylabs.middleware.connectors.json.JsonConnector;
import com.konylabs.middleware.connectors.sap.SAPConnector;
import com.konylabs.middleware.connectors.siebel.SiebelConnector;
import com.konylabs.middleware.connectors.soappackets.WebserviceSoapConnector;
import com.konylabs.middleware.connectors.xml.PlainXMLConnector;
import com.konylabs.middleware.exceptions.ProcessorException;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Service;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class ServiceConnectorUtil {
    private static final Map<String, Class<? extends Connector>> CONNECTOR_MAP = ServiceConnectorUtil.initializeConnectorMap();
    private static final Map<String, Connector> CONNECTORS = new HashMap<String, Connector>();
    private static final Logger LOGGER = Logger.getLogger(ServiceConnectorUtil.class);

    private ServiceConnectorUtil() {
    }

    public static Map<String, Class<? extends Connector>> initializeConnectorMap() {
        HashMap<String, Class<? extends Connector>> connectorMap = new HashMap<String, Class<? extends Connector>>();
        connectorMap.put("soapserviceconnector", WebserviceSoapConnector.class);
        connectorMap.put("jsonconnector", JsonConnector.class);
        connectorMap.put("plainxmlserviceconnector", PlainXMLConnector.class);
        connectorMap.put("sapconnector", SAPConnector.class);
        connectorMap.put("siebelconnector", SiebelConnector.class);
        connectorMap.put("compositeconnector", CompositeConnector.class);
        connectorMap.put("loopingconnector", LoopingConnector.class);
        connectorMap.put("dataadapterconnector", DataAdapterConnector.class);
        connectorMap.put("storageconnector", StorageConnector.class);
        connectorMap.put("javascriptconnector", JavaScriptConnector.class);
        connectorMap.put("javaconnector", JavaConnector.class);
        connectorMap.put("javaconnector2", JavaConnector2.class);
        connectorMap.put("scraperconnector", ScraperConnector.class);
        connectorMap.put("jmsconnector", JmsConnector.class);
        connectorMap.put("apiproxyconnector", APIProxyConnector.class);
        return connectorMap;
    }

    public static Connector getConnectorInstanceAndSetCallingProcessor(String serviceType, Processor processor) throws ProcessorException {
        Connector connector = null;
        if (StringUtils.isNotBlank((String)serviceType) && (connector = CONNECTORS.get(serviceType)) == null && CONNECTOR_MAP.containsKey(serviceType.toLowerCase())) {
            connector = (Connector)ReflectionUtils.newInstanceQuietly(CONNECTOR_MAP.get(serviceType.toLowerCase()));
        }
        if (connector == null) {
            LOGGER.error((Object)("Error: Service type configuration " + serviceType + " is missing or wrong"));
            throw new ProcessorException("Test Service Delegate", "10103", "Error: Service type configuration is missing or wrong. Please look at possible service types.");
        }
        connector.setCallingProcessor(processor);
        CONNECTORS.put(serviceType, connector);
        return connector;
    }

    public static Service getService(String serviceId, String objectId, ApplicationMetadata appMetadata) {
        if (appMetadata == null || StringUtils.isBlank((String)serviceId)) {
            return null;
        }
        ServiceMetadata serviceMetadata = appMetadata.getServiceMetadata(serviceId);
        if (serviceMetadata != null) {
            if (StringUtils.isNotBlank((String)objectId)) {
                serviceMetadata.setObjectId(objectId);
            }
            return serviceMetadata.getService();
        }
        return null;
    }
}

