/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.konylabs.middleware.common.MiddlewareValidationListener;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.utilities.MaskUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogChute;

public final class TemplateUtils {
    private static final Logger LOGGER = Logger.getLogger(TemplateUtils.class);

    public static String substituteTemplate(String templateName, String template, String templateParam, Map<String, Object> context) throws ConnectorException {
        VelocityContext evalContext = new VelocityContext();
        for (String key : context.keySet()) {
            Dataset dataSet;
            Object obj = context.get(key);
            if (obj instanceof Dataset && (dataSet = (Dataset)obj).getAllRecords().isEmpty()) {
                template = TemplateUtils.removeDatasetfromTemplate(template, dataSet.getId());
            }
            evalContext.put(key, obj);
        }
        try {
            String tvaluer = TemplateUtils.evaluateTemplate(template, templateParam, evalContext);
            if (LOGGER.isDebugEnabled()) {
                String debugValue = tvaluer;
                CharSequence charSequence = null;
                if (MiddlewareValidationListener.getKeyList() != null) {
                    for (String token : MiddlewareValidationListener.getKeyList()) {
                        if (!StringUtils.isNotBlank((String)token) || context.get(token) == null || !StringUtils.isNotBlank((String)String.valueOf(context.get(token)))) continue;
                        charSequence = (CharSequence)context.get(token);
                        debugValue = debugValue.replace(charSequence, "*****");
                    }
                }
                LOGGER.debug((Object)("Template Param: " + templateName + " Value  " + debugValue));
            }
            return tvaluer;
        }
        catch (IOException ex) {
            MaskUtils.maskTrace((String)ex.getMessage(), (Throwable)ex);
            LOGGER.error((Object)("Error reading the message template:" + templateName), (Throwable)ex);
            throw new ConnectorException("plainxmlserviceConnector", "9104", "Error reading the message template.", (Throwable)ex);
        }
        catch (Exception ex) {
            MaskUtils.maskTrace((String)("unable to fill the template in template param " + templateName), (Throwable)ex);
            LOGGER.error((Object)("Error reading the message template:" + templateName), (Throwable)ex);
            throw new ConnectorException("webserviceConnector", "9105", "unable to fill the message template.", (Throwable)ex);
        }
    }

    public static String evaluateTemplate(String template, String logTag, VelocityContext evalContext) throws IOException {
        StringWriter writer = new StringWriter();
        StringReader reader = new StringReader(template);
        Velocity.evaluate((Context)evalContext, (Writer)writer, (String)logTag, (Reader)reader);
        return writer.toString();
    }

    private static String removeDatasetfromTemplate(String template, String datasetId) {
        LOGGER.debug((Object)("DataSet records are empty, removing " + datasetId + " from template String"));
        String regex = "#foreach\\s*\\$" + datasetId + ".*?#end";
        template = template.replaceAll(regex, "");
        LOGGER.debug((Object)("Template after removing the regEx " + template));
        return template;
    }

    public static String substituteEndpointUrl(String requestEncoding, String endpointUrl, Map<String, Object> inputMap) throws ConnectorException {
        String mEndPointUrl = null;
        String PLUS = "\\+";
        String PERCENTILE_TWENTY = "%20";
        String EQUAL = "\\=";
        String AMPSAND = "\\&";
        try {
            HashMap<String, Object> outputMap = new HashMap<String, Object>();
            String key = null;
            String value = null;
            String actualValue = "";
            Object initVal = null;
            for (Map.Entry<String, Object> set : inputMap.entrySet()) {
                actualValue = "";
                key = set.getKey();
                initVal = set.getValue();
                if (initVal != null && initVal instanceof String) {
                    String[] paramSplit;
                    value = (String)initVal;
                    for (String par : paramSplit = value.split("\\&")) {
                        String[] valSplit = par.split("\\=");
                        if (valSplit != null && valSplit.length == 2) {
                            actualValue = actualValue + URLEncoder.encode(valSplit[0], requestEncoding) + "=" + URLEncoder.encode(valSplit[1], requestEncoding);
                            actualValue = actualValue + "&";
                            continue;
                        }
                        actualValue = value;
                    }
                    if (actualValue.endsWith("&")) {
                        actualValue = actualValue.substring(0, actualValue.length() - 1);
                    }
                    outputMap.put(key, actualValue);
                    continue;
                }
                actualValue = "";
                outputMap.put(key, actualValue);
            }
            StringBuffer UrlP = TemplateUtils.substituteTokens(endpointUrl, outputMap);
            mEndPointUrl = UrlP.toString();
            mEndPointUrl = mEndPointUrl.replaceAll("\\+", "%20");
        }
        catch (Exception ex) {
            MaskUtils.maskTrace((String)("unable to fill the endpointUrl in input param " + endpointUrl), (Throwable)ex);
            throw new ConnectorException("webserviceConnector", "9105", "unable to build endpoint url.", (Throwable)ex);
        }
        return mEndPointUrl;
    }

    public static StringBuffer substituteTokens(String url, Map<String, Object> map) {
        StringBuffer sBuffer = new StringBuffer();
        int cIdx = 0;
        block3: while (cIdx < url.length()) {
            char ch = url.charAt(cIdx);
            switch (ch) {
                case '$': {
                    StringBuffer nameBuf = new StringBuffer();
                    ++cIdx;
                    while (cIdx < url.length() && ((ch = url.charAt(cIdx)) == '_' || Character.isLetterOrDigit(ch))) {
                        nameBuf.append(ch);
                        ++cIdx;
                    }
                    if (nameBuf.length() <= 0) continue block3;
                    String value = (String)map.get(nameBuf.toString());
                    if (value != null) {
                        sBuffer.append(value);
                        break;
                    }
                    sBuffer.append("$" + nameBuf);
                    break;
                }
                default: {
                    sBuffer.append(ch);
                    ++cIdx;
                }
            }
        }
        return sBuffer;
    }

    private TemplateUtils() {
    }

    static {
        try {
            Properties props = new Properties();
            props.put("runtime.log.logsystem.class", NullLogChute.class.getName());
            props.put("directive.set.null.allowed", "true");
            Velocity.init((Properties)props);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to initialize the velocity engine", (Throwable)e);
        }
    }
}

