/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.kony.mapper.javascript.JavaScriptEngineWrapper;
import com.konylabs.middleware.common.PropertiesHelper;
import com.konylabs.middleware.common.S3Config;
import com.konylabs.middleware.config.DBConfigSubject;
import com.konylabs.middleware.config.LoggerProperties;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.devicedb.TenantException;
import com.konylabs.middleware.environment.Environment;
import com.konylabs.middleware.environment.EnvironmentConfigBean;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.environment.EnvironmentProperties;
import com.konylabs.middleware.environment.impl.AmazonMobileFabricEnvironment;
import com.konylabs.middleware.environment.impl.OnPremiseMobileFabricEnvironment;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.ReadableTenantEnvManager;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.tenant.TenantThreadLocal;
import com.konylabs.middleware.tenant.WritableTenantEnvManager;
import com.konylabs.middleware.utilities.ConfigPathUtil;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.LoggerUtility;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class TenantUtilities {
    private static final Logger LOGGER = Logger.getLogger(TenantUtilities.class);

    private static Map<String, String> getCloudProperties() {
        String adminConfPath = ConfigPathUtil.getMiddlewareHome() + "/conf";
        String confFileName = adminConfPath + File.separator + "cloud.properties";
        Properties props = PropertiesHelper.loadQuietlyFromFile((String)confFileName);
        HashMap<String, String> cloudProperties = new HashMap<String, String>();
        cloudProperties.put(EnvironmentProperties.CONSUMER_API_KEY.name(), props.getProperty("consumer_key".toUpperCase()));
        cloudProperties.put(EnvironmentProperties.CONSUMER_API_SECRET.name(), props.getProperty("consumer_secret".toUpperCase()));
        return cloudProperties;
    }

    public static TenantBean<AppCache> getTenantBean(HttpServletRequest httpServletRequest, ReadableTenantEnvManager tenantEnvManager) throws TenantException {
        if (TenantUtilities.isMultiTenant() && TenantUtilities.isHealthCheckURL(httpServletRequest.getServletPath())) {
            LOGGER.debug((Object)"Received health check / html request, So setting the tenant bean as null");
            return null;
        }
        String tenantIdentifier = tenantEnvManager.getTenantIdentifierFromServerName(httpServletRequest.getServerName());
        TenantBean tenantBean = tenantEnvManager.getTenantBean(tenantIdentifier);
        LoggerUtility.matchAndSetDynamicLogLevel(LoggerProperties.TENANT_ID_LOG_CRITERIA, tenantBean.getTenantIdentifier());
        return tenantBean;
    }

    public static boolean isHealthCheckURL(String requestURI) {
        boolean isHealthCheckURL = false;
        if (StringUtils.isNotBlank((String)requestURI) && requestURI.contains("/healthcheck")) {
            isHealthCheckURL = true;
        }
        return isHealthCheckURL;
    }

    public static boolean isMultiTenant() {
        return !ConfigUtility.getBoolean((String)"KONY_SERVER_IS_SINGLE_TENANT", (boolean)true);
    }

    public static Map<String, String> loadTenantEnvLevelProperties() {
        HashMap<String, String> tenantEnvLevelProps = new HashMap<String, String>();
        TenantUtilities.loadDefaultPropertyValues(tenantEnvLevelProps);
        TenantUtilities.loadCloudProperties(tenantEnvLevelProps);
        TenantUtilities.loadS3ConfigProperties(tenantEnvLevelProps);
        TenantUtilities.loadEnvConfigProperties(tenantEnvLevelProps);
        String environmentURL = (String)tenantEnvLevelProps.get(EnvironmentProperties.ENVIRONMENT_URL.name());
        LOGGER.debug((Object)("ENVIRONMENT_URL : " + environmentURL));
        String tenantIDFromURL = MiddlewareUtils.getTenantIDFromURL(environmentURL);
        LOGGER.debug((Object)("Tenant ID From URL : " + tenantIDFromURL));
        tenantEnvLevelProps.put(EnvironmentProperties.TENANT_ID.name(), tenantIDFromURL);
        return tenantEnvLevelProps;
    }

    public static boolean isEnvReloadRequired(boolean isEnvironmentEntryFound) {
        Environment environment = EnvironmentFactory.getEnvironment();
        boolean isEnvCreated = isEnvironmentEntryFound && !(environment instanceof OnPremiseMobileFabricEnvironment);
        boolean isEnvDeleted = !isEnvironmentEntryFound && environment instanceof OnPremiseMobileFabricEnvironment;
        return isEnvCreated || isEnvDeleted;
    }

    public static void reloadConfiguration() {
        EnvironmentConfigBean envConfigBean = EnvironmentFactory.getEnvironment().getEnvConfigBean();
        Map updatedConfig = DBConfigSubject.getInstance().reloadDatabaseProperties(envConfigBean);
        if (updatedConfig != null && updatedConfig.size() > 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Updating following config properties: " + updatedConfig.toString()));
            }
            DBConfigSubject.getInstance().notifyObservers(updatedConfig);
        }
    }

    public static void setTenantIdentifierToThreadLocal(TenantBean<AppCache> tenantBean) {
        if (TenantUtilities.isMultiTenant()) {
            TenantThreadLocal.set((String)tenantBean.getTenantIdentifier());
        }
    }

    public static String updateAndGetMemCacheKeyWithTenantIdentifier(String memCacheKey) {
        String tenantIdentifier = TenantThreadLocal.get();
        LOGGER.debug((Object)String.format("Actual mem cache key : %s", memCacheKey));
        if (StringUtils.isNotBlank((String)tenantIdentifier)) {
            memCacheKey = tenantIdentifier.concat("-").concat(memCacheKey);
            LOGGER.debug((Object)String.format("Updated mem cache key : %s", memCacheKey));
        }
        return memCacheKey;
    }

    public static void removeTenantFromCacheIfSchemaDoesNotExist(WritableTenantEnvManager tenantEnvManager, String tenantIdentifier, SQLException sqlException) {
        if (sqlException.getErrorCode() == 1049) {
            LOGGER.debug((Object)String.format("Schema doesn't exist for the tenant : %s", tenantIdentifier));
            LOGGER.debug((Object)String.format("Assuming it is decommisioned via tenant provision, removing the tenant entry %s in LRU cache", tenantIdentifier));
            tenantEnvManager.removeTenant(tenantIdentifier);
        } else {
            LOGGER.error((Object)String.format("Exception while getting connection for tenant : %s", tenantIdentifier), (Throwable)sqlException);
        }
    }

    public static String getTenantIdentifierFromDCReq(DataControllerRequest dcRequest) {
        return dcRequest != null && dcRequest.getAttribute("tenantBean") != null && StringUtils.isNotBlank((String)TenantUtilities.getTenantBeanFromDCRequest(dcRequest).getTenantIdentifier()) ? TenantUtilities.getTenantBeanFromDCRequest(dcRequest).getTenantIdentifier() : "";
    }

    public static String getSingleTenantIdentifier(ReadableTenantEnvManager tenantEnvManager) {
        Set tenantIdentifierKeys = tenantEnvManager.getActiveTenants();
        return tenantIdentifierKeys.isEmpty() ? null : (String)tenantIdentifierKeys.iterator().next();
    }

    public static JavaScriptEngineWrapper getJavaScriptEngineFromRequest(DataControllerRequest request) {
        TenantBean<AppCache> tenantBean = TenantUtilities.getTenantBeanFromDCRequest(request);
        return ((AppCache)tenantBean.getAppCache()).getJavaScriptEngineWrapper();
    }

    private static void loadCloudProperties(Map<String, String> tenantEnvLevelProps) {
        if (EnvironmentFactory.getEnvironment() instanceof AmazonMobileFabricEnvironment) {
            tenantEnvLevelProps.putAll(TenantUtilities.getCloudProperties());
        } else {
            tenantEnvLevelProps.put(EnvironmentProperties.CONSUMER_API_KEY.name(), ConfigUtility.getProperty((String)"consumer_key"));
            tenantEnvLevelProps.put(EnvironmentProperties.CONSUMER_API_SECRET.name(), ConfigUtility.getProperty((String)"consumer_secret"));
        }
    }

    private static void loadDefaultPropertyValues(Map<String, String> tenantEnvLevelProps) {
        tenantEnvLevelProps.put(S3Config.MAX_RETRIES.name(), "3");
        tenantEnvLevelProps.put(S3Config.READ_TIMEOUT.name(), "300000");
        tenantEnvLevelProps.put(S3Config.CONN_TIMEOUT.name(), "50000");
        tenantEnvLevelProps.put(S3Config.KONY_DEVICEDB_DS.name(), "java:comp/env/jdbc/KDCDB");
        tenantEnvLevelProps.put(EnvironmentProperties.HEALTH_CHECK_CACHE_DURATION.name(), "300000");
        tenantEnvLevelProps.put(EnvironmentProperties.GATEWAY_CACHE_CAPACITY.name(), "2000");
        String logFileLocation = System.getProperty("user.home") + "/konymflogs";
        tenantEnvLevelProps.put(EnvironmentProperties.DEFAULT_LOG_LOCATION.name(), logFileLocation.replaceAll("\\\\", "/"));
    }

    public static TenantBean<AppCache> getTenantBeanFromDCRequest(DataControllerRequest request) {
        return (TenantBean)request.getAttribute("tenantBean");
    }

    public static TenantBean<AppCache> getTenantBeanFromRequest(ServletRequest request) {
        return (TenantBean)request.getAttribute("tenantBean");
    }

    public static AppCache getAppCacheFromRequest(ServletRequest request) {
        TenantBean<AppCache> tenantBean = TenantUtilities.getTenantBeanFromRequest(request);
        return (AppCache)tenantBean.getAppCache();
    }

    private static void loadEnvConfigProperties(Map<String, String> tenantEnvLevelProps) {
        for (EnvironmentProperties envConfig : EnvironmentProperties.values()) {
            String value = TenantUtilities.getSystemProperty(envConfig.name());
            if (!StringUtils.isNotBlank((String)value)) continue;
            tenantEnvLevelProps.put(envConfig.name(), value);
        }
    }

    private static void loadS3ConfigProperties(Map<String, String> tenantEnvLevelProps) {
        for (S3Config config : S3Config.values()) {
            String value = TenantUtilities.getSystemProperty(config.name());
            if (!StringUtils.isNotBlank((String)value)) continue;
            tenantEnvLevelProps.put(config.name(), value);
        }
    }

    private static String getSystemProperty(String paramName) {
        String paramValue = ConfigUtility.getProperty((String)("SERVER_" + paramName));
        return StringUtils.isNotBlank((String)paramValue) ? paramValue : ConfigUtility.getProperty((String)paramName);
    }

    public static String getSingleTenantIdentifier(WritableTenantEnvManager tenantEnvManager) {
        Set tenantIdentifierKeys = tenantEnvManager.getReadableTenantEnvManager().getActiveTenants();
        return tenantIdentifierKeys.isEmpty() ? null : (String)tenantIdentifierKeys.iterator().next();
    }

    private TenantUtilities() {
    }
}

