CREATE TABLE asset_info (
  asset_id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  asset_content blob,
  asset_name varchar(255) NOT NULL,
  asset_type varchar(255) NOT NULL,
  asset_description varchar(255) ,
  col1 varchar(255)  ,
  col2 varchar(255) ,
  col3 varchar(255) ,
  col4 varchar(255) ,
  col5 varchar(255) ,
  created_by varchar(255) ,
  created_date timestamp ,
  updated_by varchar(255) ,
  updated_date timestamp,
  constraint pk_asset_info PRIMARY KEY (asset_id)
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

CREATE TABLE app_asset_info (
  app_id bigint NOT NULL,
  asset_id bigint NOT NULL,
  CONSTRAINT fk_app_info_app_id FOREIGN KEY (app_id) REFERENCES app_info (app_id) ON DELETE CASCADE,
  CONSTRAINT fk_asset_info_id FOREIGN KEY (asset_id) REFERENCES asset_info (asset_id) ON DELETE CASCADE
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};
COMMIT;

CREATE TABLE process_info (
  process_id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  process_guid varchar(255) NOT NULL,
  process_status varchar(255) NOT NULL,
  current_status varchar(255) NOT NULL,
  col1 varchar(255) ,
  col2 varchar(255) ,
  col3 varchar(255) ,
  col4 varchar(255) ,
  col5 varchar(255) ,
  created_by varchar(255) ,
  created_date timestamp ,
  updated_by varchar(255) ,
  updated_date timestamp,
  constraint pk_process_id PRIMARY KEY (process_id)
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};
COMMIT;

ALTER TABLE app_info DROP COLUMN application_guid;
CALL ADMIN_CMD('reorg table app_info');
ALTER TABLE app_info DROP FOREIGN KEY FK_app_info_app_war_info;
CALL ADMIN_CMD('reorg table app_info');
ALTER TABLE app_info DROP COLUMN app_war_id;
CALL ADMIN_CMD('reorg table app_info');

ALTER TABLE app_info ADD process_id bigint WITH DEFAULT NULL;
CALL ADMIN_CMD('reorg table app_info');
ALTER TABLE app_info ADD CONSTRAINT fk_app_info_process_id FOREIGN KEY (process_id) REFERENCES process_info (process_id) ON DELETE CASCADE;
CALL ADMIN_CMD('reorg table app_info');

ALTER TABLE app_war_info ADD COLUMN process_id bigint DEFAULT NULL;
CALL ADMIN_CMD('reorg table app_war_info');
ALTER TABLE app_war_info ADD CONSTRAINT fk_app_war_proces_id FOREIGN KEY (process_id) REFERENCES process_info (process_id) ON DELETE CASCADE;
CALL ADMIN_CMD('reorg table app_war_info');

ALTER TABLE app_war_info ADD COLUMN app_id bigint DEFAULT NULL;
CALL ADMIN_CMD('reorg table app_war_info');
ALTER TABLE app_war_info ADD CONSTRAINT fk_app_war_app_id FOREIGN KEY (app_id) REFERENCES app_info (app_id) ON DELETE CASCADE;
CALL ADMIN_CMD('reorg table app_war_info');