-- rename tables will automatically handles structure as well as data residing in it.
-- completely safe and fastest way
-- corresponding indexes will also be modified pointing to renamed table.
-- rename tables: You must also have the ALTER and DROP privileges on the original table, and the CREATE and INSERT privileges on the new table. 
-- Database automatically transfers integrity constraints, indexes, and grants on the old object to the new object.
ALTER TABLE user_roles DROP CONSTRAINT fk_user_roles_userid;
ALTER TABLE user_roles DROP CONSTRAINT fk_user_roles_roleid;
ALTER TABLE app_jar_info DROP CONSTRAINT FK_app_jar_info_jar_id;
COMMIT;
rename table users to server_users;
rename table user_roles to server_user_roles;
rename table roles to server_roles;
rename table mobilefabric_configuration to server_configuration;
rename table jar_info to server_jar_info;
rename table mobilefabric_environment to server_environment;
ALTER TABLE server_user_roles ADD CONSTRAINT fk_user_roles_userid FOREIGN KEY(userid) REFERENCES server_users(id) ON DELETE CASCADE;
ALTER TABLE server_user_roles ADD CONSTRAINT fk_user_roles_roleid FOREIGN KEY(roleid) REFERENCES server_roles(id) ON DELETE CASCADE;
ALTER TABLE app_jar_info ADD CONSTRAINT FK_app_jar_info_jar_id  FOREIGN KEY(jar_id) REFERENCES server_jar_info(jar_id) ON DELETE CASCADE;
CALL ADMIN_CMD('reorg table server_user_roles');
CALL ADMIN_CMD('reorg table app_jar_info');
commit;