CREATE TABLE users (
  id bigint	GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  userid varchar(255) NOT NULL,
  password varchar(255) NOT NULL,
  name varchar(1000) NOT NULL,
  email varchar(255) ,
  deleted char(1) ,
  enabled char(1) ,
  mobile varchar(255) ,
  col1 varchar(255)  ,
	col2 varchar(255) ,
	col3 varchar(255) ,
	col4 varchar(255) ,
	col5 varchar(255) ,
  created_by 		VARCHAR(255) ,	
	created_date 		timestamp ,	
	updated_by 		VARCHAR(255) ,
	updated_date 		timestamp ,
  constraint pk_users PRIMARY KEY (id),
  CONSTRAINT uk_users_userid UNIQUE (userid)  
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};
CREATE TABLE roles (
  id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  name varchar(255) not null,
  display_name varchar(255) ,
  description varchar(255) ,
  col1 varchar(255)  ,
  col2 varchar(255) ,
  col3 varchar(255) ,
  col4 varchar(255) ,
  col5 varchar(255) ,
  created_by 		VARCHAR(255) ,	
  created_date 		timestamp ,	
  updated_by 		VARCHAR(255) ,
  updated_date 		timestamp ,
  constraint pk_roles PRIMARY KEY (id),
  CONSTRAINT uk_roles_name UNIQUE (name)
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};
CREATE TABLE user_roles (
  roleid bigint NOT NULL,
  userid bigint NOT NULL,
  constraint pk_user_roles PRIMARY KEY (userid,roleid),
  CONSTRAINT fk_user_roles_userid FOREIGN KEY (userid) REFERENCES users (id),
  CONSTRAINT fk_user_roles_roleid FOREIGN KEY (roleid) REFERENCES roles (id)
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};
CREATE TABLE mobilefabric_configuration (
  id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  prop_name varchar(255) NOT NULL,
  prop_value varchar(255) NOT NULL,
  prop_type varchar(1000) ,
  col1 varchar(255)  ,
  col2 varchar(255) ,
  col3 varchar(255) ,
  col4 varchar(255) ,
  col5 varchar(255) ,
  created_by 		VARCHAR(255) ,	
  created_date 		timestamp ,	
  updated_by 		VARCHAR(255) ,
  updated_date 		timestamp ,
  constraint pk_mobilefabric_configuration PRIMARY KEY (id),
  CONSTRAINT uk_configuration_name UNIQUE (prop_name)
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};
CREATE TABLE mobilefabric_environment (
    id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
	environment_guid varchar(40) NOT NULL,
    mobile_fabric_version varchar(255) ,
	account_guid varchar(40) ,
	account_id integer,
	environment_name varchar(255) ,	 
	environment_service_url  varchar(255) ,
	account_auth_url  varchar(255)  ,
	environment_auth_url  varchar(255) ,
	account_api_base_url varchar(255) ,
	account_ui_base_url varchar(255) ,
	col1 varchar(255)  ,
	col2 varchar(255) ,
	col3 varchar(255) ,
	col4 varchar(255) ,
	col5 varchar(255) ,
	created_by 		VARCHAR(255) ,	
	created_date 		timestamp ,	
	updated_by 		VARCHAR(255) ,
	updated_date 		timestamp ,
  constraint pk_mobilefabric_environment PRIMARY KEY (id),
  constraint uk_mobilefabric_environment UNIQUE (environment_guid) 
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};
CREATE TABLE app_war_info (
  app_war_id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  created_date timestamp ,
  created_by varchar(255) ,
  updated_date timestamp ,
  updated_by varchar(255) ,
  col1 varchar(255)  ,
  col2 varchar(255) ,
  col3 varchar(255) ,
  col4 varchar(255) ,
  col5 varchar(255) ,
  war_name varchar(255) not null,
  war_content blob(60M),
  constraint pk_app_war_info PRIMARY KEY (app_war_id),
  constraint uk_app_war_info UNIQUE (war_name)
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};
CREATE TABLE app_info (
	app_id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
	app_content blob(20M),
 	app_name varchar(255) NOT NULL,
 	application_guid varchar(255) ,
  	application_description varchar(255) ,
  	app_war_id bigint ,
 	col1 varchar(255)  ,
	col2 varchar(255) ,
	col3 varchar(255) ,
	col4 varchar(255) ,
	col5 varchar(255) ,
	created_by 		VARCHAR(255) ,	
	created_date 		timestamp ,	
	updated_by 		VARCHAR(255) ,
	updated_date 		timestamp ,
	constraint pk_app_infob PRIMARY KEY (app_id),  
	constraint uk_app_info UNIQUE (app_name),
	CONSTRAINT FK_app_info_app_war_info FOREIGN KEY (app_war_id) REFERENCES app_war_info (app_war_id) ON DELETE CASCADE
 ) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};
 CREATE TABLE jar_info (
  	jar_id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  	jar_content blob(20M),
  	jar_name varchar(255) NOT NULL,
  	col1 varchar(255)  ,
	col2 varchar(255) ,
	col3 varchar(255) ,
	col4 varchar(255) ,
	col5 varchar(255) ,
	created_by 		VARCHAR(255) ,	
	created_date 		timestamp ,	
	updated_by 		VARCHAR(255) ,
	updated_date 		timestamp ,
 	 constraint pk_jar_info PRIMARY KEY (jar_id),
 	 constraint uk_jar_info UNIQUE (jar_name)
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};
CREATE TABLE app_jar_info (
  app_id bigint NOT NULL,
  jar_id bigint NOT NULL,
  CONSTRAINT FK_app_jar_info_jar_id FOREIGN KEY (jar_id) REFERENCES jar_info (jar_id) ON DELETE CASCADE,
  CONSTRAINT FK_app_jar_info_app_info FOREIGN KEY (app_id) REFERENCES app_info (app_id) ON DELETE CASCADE
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};
CREATE TABLE build_version (
   	build_version VARCHAR(255),
	build_date 	timestamp
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};
INSERT INTO build_version(build_version, build_date) values ('#SERVER_BUILD_VERSION#', CURRENT_TIMESTAMP);
INSERT INTO roles(description, name, display_name) VALUES ('Represents the system administrator','ROLE_ADMIN', 'Admin');
INSERT INTO roles(description, name, display_name) VALUES ('Represents the report viewer who uses application for report viewing','ROLE_REPORT_VIEWER', 'Report Viewer');
INSERT INTO roles(description, name, display_name) VALUES ('Represents the end user who publish the application','ROLE_PUBLISHER', 'Publisher');
INSERT INTO users(userId, name, password, mobile, email, deleted, enabled, created_by, updated_by, created_date, updated_date) VALUES ('admin','Administrator','240be518fabd2724ddb6f04eeb1da5967448d7e831c08c8fa822809f74c720a9','1234567890','admin@kony.com','0', '1','admin','admin', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);
INSERT INTO users(userId, name, password, mobile, email, deleted, enabled, created_by, updated_by, created_date, updated_date) VALUES ('mobilefabricadmin','MobileFabric Administrator','1afc111ca0e435623faca0e5ab5a27d69547f1cfa1a6e4ff99cea31a2cc37674','1234567890','mobilefabricadmin@kony.com','0', '1','mobilefabricadmin','mobilefabricadmin', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);
INSERT INTO user_roles(userid, roleid) VALUES (1,1);
INSERT INTO user_roles(userid, roleid) VALUES (2,1);
commit;