CREATE TABLE SERVER_JOB (
  JOB_ID bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  JOB_NAME varchar(50) NOT NULL,
  JOB_DESCRIPTION varchar(255) ,
  JOB_FREQUENCY varchar(255) NOT NULL,
  JOB_SERVICE_TYPE varchar(100) NOT NULL,
  JOB_SOURCE_TYPE varchar(100) NOT NULL,
  JOB_INFO CLOB(2M) ,
  JOB_FREQUENCY_INFO CLOB(2M) ,
  JOB_RUNAT varchar(100) NOT NULL,
  JOB_NODE varchar(100) NOT NULL,
  JOB_STORE_TYPE varchar(100) NOT NULL,
  JOB_MODE varchar(100) NOT NULL,
  JOB_HISTORY varchar(100) NOT NULL,
  JOB_HISTORY_RETENTION_PERIOD varchar(100) ,
  JOB_SUCCESS_CRITERIA varchar(255) ,
  JOB_ACTIVE char(1) NOT NULL,
  CREATED_BY varchar(255) ,
  CREATED_DATE timestamp ,
  UPDATED_BY varchar(255) ,
  UPDATED_DATE timestamp,
  CONSTRAINT PK_SERVER_JOB PRIMARY KEY (JOB_ID),
  CONSTRAINT UK_SERVER_JOB UNIQUE (JOB_NAME)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};
  
CREATE TABLE SERVER_JOB_HISTORY (
  JOB_RUN_ID bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  JOB_ID bigint NOT NULL ,
  JOB_START_TIME timestamp ,
  JOB_END_TIME timestamp ,
  JOB_RUN_REQUEST_HEADER CLOB(2M) ,
  JOB_RUN_REQUEST CLOB(2M) ,
  JOB_RUN_RESPONSE_HEADER CLOB(2M) ,
  JOB_RUN_RESPONSE CLOB(2M) ,
  JOB_FREQUENCY varchar(255),
  JOB_STATUS varchar(100) ,
  CREATED_BY varchar(255) ,
  CREATED_DATE timestamp ,
  UPDATED_BY varchar(255) ,
  UPDATED_DATE timestamp,
  CONSTRAINT PK_SERVER_JOB_HISTORY_ID PRIMARY KEY (JOB_RUN_ID),
  CONSTRAINT FK_SERVER_JOB_JOB_ID FOREIGN KEY (JOB_ID) REFERENCES SERVER_JOB (JOB_ID) ON DELETE CASCADE
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};
  
create table server_qz_job_details(
	sched_name varchar(120) not null,
	job_name varchar(80) not null,
	job_group varchar(80) not null,
	description varchar(120),
	job_class_name varchar(128) not null,
	is_durable integer not null,
	is_nonconcurrent integer not null,
	is_update_data integer not null,
	requests_recovery integer not null,
	job_data blob(2000),
	primary key (sched_name,job_name,job_group)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

create table server_qz_triggers(
	sched_name varchar(120) not null,
	trigger_name varchar(80) not null,
	trigger_group varchar(80) not null,
	job_name varchar(80) not null,
	job_group varchar(80) not null,
	description varchar(120),
	next_fire_time bigint,
	prev_fire_time bigint,
	priority integer,
	trigger_state varchar(16) not null,
	trigger_type varchar(8) not null,
	start_time bigint not null,
	end_time bigint,
	calendar_name varchar(80),
	misfire_instr smallint,
	job_data blob(2000),
	primary key (sched_name,trigger_name,trigger_group),
	foreign key (sched_name,job_name,job_group) references server_qz_job_details(sched_name,job_name,job_group)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

create table server_qz_simple_triggers(
	sched_name varchar(120) not null,
	trigger_name varchar(80) not null,
	trigger_group varchar(80) not null,
	repeat_count bigint not null,
	repeat_interval bigint not null,
	times_triggered bigint not null,
	primary key (sched_name,trigger_name,trigger_group),
	foreign key (sched_name,trigger_name,trigger_group) references server_qz_triggers(sched_name,trigger_name,trigger_group)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

create table server_qz_cron_triggers(
	sched_name varchar(120) not null,
	trigger_name varchar(80) not null,
	trigger_group varchar(80) not null,
	cron_expression varchar(120) not null,
	time_zone_id varchar(80),
	primary key (sched_name,trigger_name,trigger_group),
	foreign key (sched_name,trigger_name,trigger_group) references server_qz_triggers(sched_name,trigger_name,trigger_group)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

CREATE TABLE server_qz_simprop_triggers(
    sched_name varchar(120) not null,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    STR_PROP_1 VARCHAR(512),
    STR_PROP_2 VARCHAR(512),
    STR_PROP_3 VARCHAR(512),
    INT_PROP_1 INT,
    INT_PROP_2 INT,
    LONG_PROP_1 BIGINT,
    LONG_PROP_2 BIGINT,
    DEC_PROP_1 NUMERIC(13,4),
    DEC_PROP_2 NUMERIC(13,4),
    BOOL_PROP_1 VARCHAR(1),
    BOOL_PROP_2 VARCHAR(1),
    PRIMARY KEY (sched_name,TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (sched_name,TRIGGER_NAME,TRIGGER_GROUP) 
    REFERENCES server_qz_TRIGGERS(sched_name,TRIGGER_NAME,TRIGGER_GROUP)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

create table server_qz_blob_triggers(
	sched_name varchar(120) not null,
	trigger_name varchar(80) not null,
	trigger_group varchar(80) not null,
	blob_data blob(2000),
	primary key (sched_name,trigger_name,trigger_group),
	foreign key (sched_name,trigger_name,trigger_group) references server_qz_triggers(sched_name,trigger_name,trigger_group)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

create table server_qz_calendars(
	sched_name varchar(120) not null,
	calendar_name varchar(80) not null,
	calendar blob(2000) not null,
	primary key (calendar_name)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

create table server_qz_fired_triggers(
	sched_name varchar(120) not null,
	entry_id varchar(95) not null,
	trigger_name varchar(80) not null,
	trigger_group varchar(80) not null,
	instance_name varchar(80) not null,
	fired_time bigint not null,
	sched_time bigint not null,
	priority integer not null,
	state varchar(16) not null,
	job_name varchar(80),
	job_group varchar(80),
	is_nonconcurrent integer,
	requests_recovery integer,
	primary key (sched_name,entry_id)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

create table server_qz_paused_trigger_grps(
	sched_name varchar(120) not null,
	trigger_group varchar(80) not null,
	primary key (sched_name,trigger_group)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

create table server_qz_scheduler_state(
	sched_name varchar(120) not null,
	instance_name varchar(80) not null,
	last_checkin_time bigint not null,
	checkin_interval bigint not null,
	primary key (sched_name,instance_name)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

create table server_qz_locks(
	sched_name varchar(120) not null,
	lock_name varchar(40) not null,
	primary key (sched_name,lock_name)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.scheduler.skipUpdateCheck', 'true', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.dataSource', 'mobileFabricQuartzDS', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.scheduler.instanceId', 'AUTO', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.acquireTriggersWithinLock', 'true', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.scheduler.instanceName', 'MobileFabric_Scheduler', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.class', 'org.quartz.impl.jdbcjobstore.JobStoreTX', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.threadPool.class', 'org.quartz.simpl.SimpleThreadPool', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.driverDelegateClass', 'org.quartz.impl.jdbcjobstore.StdJDBCDelegate', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.isClustered', 'false', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.threadPool.threadCount', '5', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.useProperties', 'false', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.tablePrefix', 'server_qz_', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.misfireThreshold', '60000', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.selectWithLockSQL', 'SELECT * FROM {0}LOCKS WHERE LOCK_NAME = ? FOR UPDATE', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

insert into server_configuration(prop_name, prop_value, prop_type, created_date, updated_date) values('SERVER_CLEANUP_JOB_FREQUENCY', '0 0 0 1/1 * ? *', 'MobileFabricJob', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);