CREATE TABLE server_client_asset_info (
  client_asset_id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  client_asset_content blob,
  client_asset_name varchar(50) NOT NULL,
  client_asset_type varchar(50) NOT NULL,
  client_asset_parent_type varchar(50) NOT NULL,
  client_asset_description varchar(50) ,
  col1 varchar(50)  ,
  col2 varchar(50) ,
  col3 varchar(50) ,
  col4 varchar(50) ,
  col5 varchar(50) ,
  created_by varchar(50) ,
  created_date timestamp ,
  updated_by varchar(50) ,
  updated_date timestamp,
  constraint pk_client_asset_info PRIMARY KEY (client_asset_id)
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

CREATE TABLE server_app_client_asset_info (
  app_id bigint NOT NULL,
  client_asset_id bigint NOT NULL,
  CONSTRAINT fk_app_info_app_id_client_asset FOREIGN KEY (app_id) REFERENCES app_info (app_id) ON DELETE CASCADE,
  CONSTRAINT fk_client_asset_info_id FOREIGN KEY (client_asset_id) REFERENCES server_client_asset_info (client_asset_id) ON DELETE CASCADE
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};
COMMIT;
