CREATE TABLE server_log_devicerequestdata (
  request_id varchar(50) NOT NULL,
  app_id varchar(50),  
  device_id varchar(255),
  user_id varchar(128),
  created_by varchar(255) ,
  created_date timestamp ,
  updated_by varchar(255) ,
  updated_date timestamp,
  request_method varchar(50),  
  payload  blob(2G),
  request_size INT,
  CONSTRAINT pk_request_id PRIMARY KEY (request_id)
  ) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};
 
  CREATE TABLE server_log_deviceresponsedata (
  request_id varchar(50) NOT NULL,
  created_by varchar(255) ,
  created_date timestamp ,
  updated_by varchar(255) ,
  updated_date timestamp,
  opstatus INT,   
  payload  blob(2G),
  response_size INT,
   CONSTRAINT fk_log_responseData FOREIGN KEY (request_id)
  REFERENCES server_log_devicerequestdata (request_id)
  ) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};
  
CREATE TABLE server_log_events (
  request_id varchar(50) NOT NULL,
  event_type varchar(50),
  created_by varchar(255) ,
  created_date timestamp ,
  updated_by varchar(255) ,
  updated_date timestamp,
  payload  blob(2G),
   CONSTRAINT fk_log_datasource FOREIGN KEY (request_id)
  REFERENCES server_log_devicerequestdata (request_id)
  ) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};
  
insert into server_configuration(prop_name, prop_value, created_date , updated_date) values('KONY_SERVER_TRACELOGS_LEVEL','OFF', CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);