CREATE TABLE server_timer_metrics (
	service_name VARCHAR(255) NOT NULL,
	service_version VARCHAR(25) NOT NULL,
	parent_service_name VARCHAR(255),
	operation_name VARCHAR(255) NOT NULL,
	service_category VARCHAR(35) NOT NULL,
	service_type VARCHAR(35) NOT NULL,
	verb VARCHAR(25) NOT NULL,
	instance_id varchar(35) NOT NULL,
	count integer,
	service_min DECIMAL(9,3),
	service_max DECIMAL(9,3),
	service_mean DECIMAL(9,3),
	service_stddev DECIMAL(9,3),
	pre_processor_min DECIMAL(9,3),
	pre_processor_max DECIMAL(9,3),
	pre_processor_mean DECIMAL(9,3),
	pre_processor_stddev DECIMAL(9,3),
	post_processor_min DECIMAL(9,3),
	post_processor_max DECIMAL(9,3),
	post_processor_mean DECIMAL(9,3),
	post_processor_stddev DECIMAL(9,3),
	request_mapper_min DECIMAL(9,3),
	request_mapper_max DECIMAL(9,3),
	request_mapper_mean DECIMAL(9,3),
	request_mapper_stddev DECIMAL(9,3),
	response_mapper_min DECIMAL(9,3),
	response_mapper_max DECIMAL(9,3),
	response_mapper_mean DECIMAL(9,3),
	response_mapper_stddev DECIMAL(9,3),
	backend_request_min DECIMAL(9,3),
	backend_request_max DECIMAL(9,3),
	backend_request_mean DECIMAL(9,3),
	backend_request_stddev DECIMAL(9,3),
	parsing_min DECIMAL(9,3),
	parsing_max DECIMAL(9,3),
	parsing_mean DECIMAL(9,3),
	parsing_stddev DECIMAL(9,3),
	url_provider_processing_min DECIMAL(9,3),
	url_provider_processing_max DECIMAL(9,3),
	url_provider_processing_mean DECIMAL(9,3),
	url_provider_processing_stddev DECIMAL(9,3),
	timestamp TIMESTAMP NOT NULL
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

create index idx_servermetrics_inst_id on server_timer_metrics(instance_id);
create index idx_servermetrics_ts on server_timer_metrics(timestamp);
