CREATE TABLE webapp
  (
     webapp_id      BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
     webapp_name    VARCHAR(64) UNIQUE NOT NULL,
     webapp_version VARCHAR(16),
     webapp_zip_name    VARCHAR(64),
	 webapp_channel    VARCHAR(128),
     webapp_properties  CLOB,
     created_by     VARCHAR(64),
     created_date   TIMESTAMP,
     updated_by     VARCHAR(64),
     updated_date   TIMESTAMP,
     col1 		VARCHAR(64),
     col2 		VARCHAR(64),
     col3 		VARCHAR(64),
     col4 		VARCHAR(64),
     col5 		VARCHAR(64),
     PRIMARY KEY(webapp_id)
  )IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

  
CREATE TABLE webapp_asset
  (
     webapp_asset_id      BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
     webapp_asset_content BLOB,
     webapp_asset_name    VARCHAR(64),
     webapp_asset_type    VARCHAR(16) DEFAULT 'JAR',
     created_by           VARCHAR(64),
     created_date         TIMESTAMP,
     updated_by           VARCHAR(64),
     updated_date         TIMESTAMP,
     col1 		VARCHAR(64),
     col2 		VARCHAR(64),
     col3 		VARCHAR(64),
     col4 		VARCHAR(64),
     col5 		VARCHAR(64),
     PRIMARY KEY (webapp_asset_id)	
  )IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};
  
CREATE TABLE webapp_content
  (
     webapp_content_id   BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
     webapp_id           BIGINT NOT NULL,
     webapp_content_part BLOB,
     webapp_resource_path     VARCHAR(255) NOT NULL,
     created_by     VARCHAR(64),
     created_date   TIMESTAMP,
     updated_by     VARCHAR(64),
     updated_date   TIMESTAMP,
     col1 		VARCHAR(64),
     col2 		VARCHAR(64),
     col3 		VARCHAR(64),
     col4 		VARCHAR(64),
     col5 		VARCHAR(64),
     CONSTRAINT fk_webapp_content_id FOREIGN KEY (webapp_id) REFERENCES webapp(webapp_id) ON DELETE CASCADE,
     PRIMARY KEY (webapp_content_id)
  )IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};
  
  create index idx_webapp_content_webapp_id on webapp_content(webapp_id);
  
  CREATE TABLE webapp_asset_info
  (
     webapp_id       BIGINT NOT NULL,
     webapp_asset_id BIGINT NOT NULL,
     CONSTRAINT fk_asset_info_webapp_id FOREIGN KEY (webapp_id) REFERENCES webapp(webapp_id),
     CONSTRAINT fk_asset_info_webapp_asset_id FOREIGN KEY (webapp_asset_id) REFERENCES webapp_asset(webapp_asset_id)
  )IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};
  
  create index idx_asset_info_webapp_id on webapp_asset_info(webapp_id);
  create index idx_asset_info_webapp_asset_id on webapp_asset_info(webapp_asset_id);