CREATE TABLE upload_cache (
  id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  req_hash varchar(50)  NOT NULL,
  response clob(20M),
  iserror smallint DEFAULT 0 NOT NULL,
  firsthittime bigint NOT NULL,
  created_date timestamp,
  updated_date timestamp,
  updated_by varchar(50),
  created_by varchar(50),
  constraint pk_upload_cache_id PRIMARY KEY (id),
  CONSTRAINT uk_upload_cache_req_hash UNIQUE (req_hash)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};


INSERT INTO server_configuration(prop_name, prop_value,created_date, updated_date) VALUES('upload.requestResubmitTime', '1800000',CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);
INSERT INTO server_configuration(prop_name, prop_value,created_date, updated_date) VALUES('upload.responseWaitTime', '30000',CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);