DROP TABLE server_timer_metrics;

CREATE TABLE server_timer_metrics (
	service_name VARCHAR(255) NOT NULL,
	service_version VARCHAR(25) NOT NULL,
	parent_service_name VARCHAR(255),
	operation_name VARCHAR(255) NOT NULL,
	service_category VARCHAR(35) NOT NULL,
	service_type VARCHAR(35) NOT NULL,
	verb VARCHAR(25) NOT NULL,
	instance_id varchar(35) NOT NULL,
	count integer,
	service_min integer,
	service_max integer,
	service_mean integer,
	service_stddev integer,
	pre_processor_min integer,
	pre_processor_max integer,
	pre_processor_mean integer,
	pre_processor_stddev integer,
	post_processor_min integer,
	post_processor_max integer,
	post_processor_mean integer,
	post_processor_stddev integer,
	request_mapper_min integer,
	request_mapper_max integer,
	request_mapper_mean integer,
	request_mapper_stddev integer,
	response_mapper_min integer,
	response_mapper_max integer,
	response_mapper_mean integer,
	response_mapper_stddev integer,
	backend_request_min integer,
	backend_request_max integer,
	backend_request_mean integer,
	backend_request_stddev integer,
	parsing_min integer,
	parsing_max integer,
	parsing_mean integer,
	parsing_stddev integer,
	url_provider_processing_min integer,
	url_provider_processing_max integer,
	url_provider_processing_mean integer,
	url_provider_processing_stddev integer,
	timestamp TIMESTAMP NOT NULL
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

create index idx_servermetrics_inst_id on server_timer_metrics(instance_id);
create index idx_servermetrics_ts on server_timer_metrics(timestamp);
