ALTER TABLE upload_cache ALTER COLUMN created_date SET DEFAULT CURRENT_TIMESTAMP;

CREATE TABLE upload_cache1 (
  id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  req_hash varchar(50)  NOT NULL,
  response blob(20M),
  iserror smallint DEFAULT 0 NOT NULL,
  firsthittime bigint NOT NULL,
  created_date timestamp default CURRENT_TIMESTAMP,
  updated_date timestamp,
  updated_by varchar(50),
  created_by varchar(50),
  constraint pk_upload_cache1_id PRIMARY KEY (id),
  CONSTRAINT uk_upload_cache1_req_hash UNIQUE (req_hash)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};


CREATE TABLE upload_cache2 (
  id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  req_hash varchar(50)  NOT NULL,
  response blob(20M),
  iserror smallint DEFAULT 0 NOT NULL,
  firsthittime bigint NOT NULL,
  created_date timestamp default CURRENT_TIMESTAMP,
  updated_date timestamp,
  updated_by varchar(50),
  created_by varchar(50),
  constraint pk_upload_cache2_id PRIMARY KEY (id),
  CONSTRAINT uk_upload_cache2_req_hash UNIQUE (req_hash)
) IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};



CREATE VIEW upload_cache_view AS
   SELECT
	        id, req_hash, response, iserror, firsthittime
	    FROM
	        upload_cache
	    UNION all SELECT
	        id, req_hash, response, iserror, firsthittime
	    FROM
	        upload_cache1
	    UNION all  SELECT
	        id, req_hash, response, iserror, firsthittime
	    FROM
	        upload_cache2;

