CREATE TABLE server_node_notifier (
  id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER) NOT NULL,
  process_id bigint NOT NULL,
  action varchar(50) NOT NULL,
  status varchar(50) ,
  status_details varchar(255) ,
  created_by varchar(50) ,
  created_date timestamp  default CURRENT_TIMESTAMP,
  updated_by varchar(50) ,
  updated_date timestamp
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};

CREATE TABLE server_node_status (
  id bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER) NOT NULL,
  node_id varchar(50) NOT NULL,
  node_status varchar(50) NOT NULL,
  process_id bigint,
  process_action varchar(50),
  process_status varchar(50),
  err_msg varchar(255),
  health_acknowledge bigint,
  publish_timer_disabled smallint DEFAULT 0 NOT NULL,
  created_by varchar(50) ,
  created_date timestamp  default CURRENT_TIMESTAMP,
  updated_by varchar(50) ,
  updated_date timestamp
) in ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE} LONG IN ${KONY_SERVER_LOB_TABLESPACE};