DROP TABLE `server_timer_metrics`;

CREATE TABLE `server_timer_metrics` (
  `service_name` varchar(255) NOT NULL,
  `service_version` varchar(25) NOT NULL,
  `parent_service_name` varchar(255),
  `operation_name` varchar(255) NOT NULL,
  `service_category` varchar(35) NOT NULL,
  `service_type` varchar(35) NOT NULL,
  `verb` varchar(25) NOT NULL,
  `instance_id` varchar(35) NOT NULL,
  `count` int(10) unsigned,
  `service_min` int(10) unsigned,
  `service_max` int(10) unsigned,
  `service_mean` int(10) unsigned,
  `service_stddev` int(10) unsigned,
  `pre_processor_min` int(10) unsigned,
  `pre_processor_max` int(10) unsigned,
  `pre_processor_mean` int(10) unsigned,
  `pre_processor_stddev` int(10) unsigned,
  `post_processor_min` int(10) unsigned,
  `post_processor_max` int(10) unsigned,
  `post_processor_mean` int(10) unsigned,
  `post_processor_stddev` int(10) unsigned,
  `request_mapper_min` int(10) unsigned,
  `request_mapper_max` int(10) unsigned,
  `request_mapper_mean` int(10) unsigned,
  `request_mapper_stddev` int(10) unsigned,
  `response_mapper_min` int(10) unsigned,
  `response_mapper_max` int(10) unsigned,
  `response_mapper_mean` int(10) unsigned,
  `response_mapper_stddev` int(10) unsigned,
  `backend_request_min` int(10) unsigned,
  `backend_request_max` int(10) unsigned,
  `backend_request_mean` int(10) unsigned,
  `backend_request_stddev` int(10) unsigned,
  `parsing_min` int(10) unsigned,
  `parsing_max` int(10) unsigned,
  `parsing_mean` int(10) unsigned,
  `parsing_stddev` int(10) unsigned,
  `url_provider_processing_min` int(10) unsigned,
  `url_provider_processing_max` int(10) unsigned,
  `url_provider_processing_mean` int(10) unsigned,
  `url_provider_processing_stddev` int(10) unsigned,
  `timestamp` timestamp NOT NULL,
  KEY `idx_servermetrics_inst_id` (`instance_id`),
  KEY `idx_servermetrics_ts` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;