CREATE TABLE asset_info (
  asset_id number(20) NOT NULL ,
  asset_content blob NULL,
  asset_name varchar2(255) ,
  asset_type varchar2(255) ,
  asset_description varchar2(255) ,
  col1 varchar2(255) ,
  col2 varchar2(255) ,
  col3 varchar2(255) ,
  col4 varchar2(255) ,
  col5 varchar2(255) ,
  created_by varchar2(255) ,
  created_date DATE ,
  updated_by varchar2(255) ,
  updated_date DATE ,
  constraint pk_asset_info PRIMARY KEY(asset_id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
  ) LOB (asset_content) store as LOB_asset_info ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
  tablespace ${KONY_SERVER_DATA_TABLESPACE};
  
CREATE TABLE app_asset_info (
  app_id number(20) NOT NULL,
  asset_id number(20) NOT NULL,
  CONSTRAINT fk_asset_info_id FOREIGN KEY (asset_id) REFERENCES asset_info (asset_id),
  CONSTRAINT fk_app_info_app_id FOREIGN KEY (app_id) REFERENCES app_info (app_id)
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE TABLE process_info (
  process_id number(20) NOT NULL ,
  process_guid varchar2(255) ,
  process_status varchar2(255) ,
  current_status varchar2(255) ,
  col1 varchar2(255) ,
  col2 varchar2(255) ,
  col3 varchar2(255) ,
  col4 varchar2(255) ,
  col5 varchar2(255) ,
  created_by varchar2(255) ,
  created_date DATE ,
  updated_by varchar2(255) ,
  updated_date DATE ,
  constraint pk_process_info PRIMARY KEY(process_id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
  )tablespace ${KONY_SERVER_DATA_TABLESPACE};
  
  
ALTER TABLE app_info DROP COLUMN application_guid;
ALTER TABLE app_info DROP CONSTRAINT fk_app_war_id;
ALTER TABLE app_info DROP COLUMN app_war_id;
ALTER TABLE app_info ADD process_id number(20) DEFAULT NULL;
ALTER TABLE app_info ADD CONSTRAINT fk_app_info_process_id FOREIGN KEY (process_id) REFERENCES process_info (process_id);

ALTER TABLE app_war_info ADD process_id number(20) DEFAULT NULL;
ALTER TABLE app_war_info ADD CONSTRAINT fk_app_war_proces_id FOREIGN KEY (process_id) REFERENCES process_info (process_id);

ALTER TABLE app_war_info ADD app_id number(20) DEFAULT NULL;
ALTER TABLE app_war_info ADD CONSTRAINT fk_app_war_app_id FOREIGN KEY (app_id) REFERENCES app_info (app_id);

