-- rename tables will automatically handles structure as well as data residing in it.
-- completely safe and fastest way
-- corresponding indexes will also be modified pointing to renamed table.
-- rename tables: You must also have the ALTER and DROP privileges on the original table, and the CREATE and INSERT privileges on the new table. 
-- Database automatically transfers integrity constraints, indexes, and grants on the old object to the new object.

create or replace procedure RENAME_OBJECTS (orig_obj_name in varchar2, new_obj_name in varchar2)
as
lv_sql_str varchar2(1000);
lv_exists number(1);
begin
select count(1) into lv_exists from user_objects where object_name=orig_obj_name and object_type in ('TABLE','SEQUENCE');
if lv_exists = 1 then
lv_sql_str := 'rename '||orig_obj_name||' to '||new_obj_name;
dbms_output.put_line (lv_sql_str);
execute immediate lv_sql_str;
else
dbms_output.put_line('ERROR:'||orig_obj_name||' does not exist!');
end if;
end;
/

begin
	RENAME_OBJECTS('USERS','SERVER_USERS');
	RENAME_OBJECTS('USER_ROLES','SERVER_USER_ROLES');
	RENAME_OBJECTS('ROLES','SERVER_ROLES');
	RENAME_OBJECTS('MOBILEFABRIC_CONFIGURATION','SERVER_CONFIGURATION');
	RENAME_OBJECTS('JAR_INFO','SERVER_JAR_INFO');
	RENAME_OBJECTS('MOBILEFABRIC_ENVIRONMENT','SERVER_ENVIRONMENT');
	RENAME_OBJECTS('SEQ_USERS','SEQ_SERVER_USERS');
	RENAME_OBJECTS('SEQ_ROLES','SEQ_SERVER_ROLES');
	RENAME_OBJECTS('SEQ_MOBILEFABRIC_CONFIGURATION','SEQ_SERVER_CONFIGURATION');
	RENAME_OBJECTS('SEQ_JAR_INFO','SEQ_SERVER_JAR_INFO');
	RENAME_OBJECTS('SEQ_MOBILEFABRIC_ENVIRONMENT','SEQ_SERVER_ENVIRONMENT');
end;
/ 

drop procedure rename_objects;

-- recreate triggers with renamed tables and sequences.
drop trigger TRG_users;
CREATE OR REPLACE TRIGGER trg_server_users BEFORE INSERT ON server_users
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select seq_server_users.nextval into :new.id from dual; 
   END IF;

END;
/

drop trigger TRG_roles;
CREATE OR REPLACE TRIGGER trg_server_roles BEFORE INSERT ON server_roles
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select seq_server_roles.nextval into :new.id from dual; 
   END IF;

END;
/

drop trigger TRG_mobilefabric_configuration;

CREATE OR REPLACE TRIGGER trg_server_configuration BEFORE INSERT ON server_configuration
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select seq_server_configuration.nextval into :new.id from dual;
   END IF;

END;
/

drop trigger TRG_mobilefabric_environment;

CREATE OR REPLACE TRIGGER trg_server_environment BEFORE INSERT ON server_environment
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN 
      select seq_server_environment.nextval into :new.id from dual;
   END IF;

END;
/

drop trigger TRG_jar_info;
CREATE OR REPLACE TRIGGER trg_server_jar_info BEFORE INSERT ON server_jar_info
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.jar_id IS NULL THEN
      select seq_server_jar_info.nextval into :new.jar_id from dual;
   END IF;

END;
/