CREATE TABLE server_app_config (
  app_config_id number(20) NOT NULL ,
  app_id number(20) NOT NULL ,
  config_type varchar2(50) NULL,
  configuration clob NULL,
  created_by varchar2(255) ,
  created_date DATE ,
  updated_by varchar2(255) ,
  updated_date DATE ,
  constraint pk_server_app_config_id PRIMARY KEY(app_config_id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  CONSTRAINT fk_server_app_config_app_id FOREIGN KEY (app_id) REFERENCES app_info (app_id)
  ) LOB (configuration) store as server_app_config ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
  tablespace ${KONY_SERVER_DATA_TABLESPACE};
  
  
CREATE SEQUENCE SEQ_SERVER_APP_CONFIG
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;  

CREATE OR REPLACE TRIGGER TRG_SERVER_APP_CONFIG BEFORE INSERT ON server_app_config
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.app_config_id IS NULL THEN
      select SEQ_SERVER_APP_CONFIG.nextval into :new.app_config_id from dual;
   END IF;

END;
/