-- users;
CREATE TABLE users (
  id       		number(20)		NOT NULL ,
  userid varchar2(255) NOT NULL,
  password varchar2(255) NOT NULL,
  name varchar2(1000) NOT NULL,
  email varchar2(255) DEFAULT NULL,
  deleted char(1) DEFAULT NULL,
  enabled char(1) DEFAULT NULL,
  mobile varchar2(255) DEFAULT NULL,
  col1 varchar2(255) DEFAULT NULL ,
	col2 varchar2(255) DEFAULT NULL,
	col3 varchar2(255) DEFAULT NULL,
	col4 varchar2(255) DEFAULT NULL,
	col5 varchar2(255) DEFAULT NULL,
  created_by 		varchar2(255) DEFAULT NULL,	
	created_date 		DATE DEFAULT NULL,	
	updated_by 		varchar2(255) DEFAULT NULL,
	updated_date 		DATE DEFAULT NULL,
  constraint pk_users PRIMARY KEY(id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
	constraint uk_users unique(userid) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_users
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;

-- DELIMITER / 

CREATE OR REPLACE TRIGGER TRG_users BEFORE INSERT ON users
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select SEQ_users.nextval into :new.id from dual; 
   END IF;

END;
/

-- DELIMITER ;

-- roles;
CREATE TABLE roles (
  id number(20) NOT NULL ,
  name varchar2(255) DEFAULT NULL,
  display_name varchar2(255) DEFAULT NULL,
  description varchar2(255) DEFAULT NULL,
  col1 varchar2(255) DEFAULT NULL ,
  col2 varchar2(255) DEFAULT NULL,
  col3 varchar2(255) DEFAULT NULL,
  col4 varchar2(255) DEFAULT NULL,
  col5 varchar2(255) DEFAULT NULL,
  created_by 		varchar2(255) DEFAULT NULL,	
  created_date 		DATE DEFAULT NULL,	
  updated_by 		varchar2(255) DEFAULT NULL,
  updated_date 		DATE DEFAULT NULL,
  constraint pk_roles PRIMARY KEY(id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  constraint uk_roles unique(name) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_roles
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;

-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_roles BEFORE INSERT ON roles
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select SEQ_roles.nextval into :new.id from dual; 
   END IF;

END;
/

-- DELIMITER ;

 -- user_roles;
CREATE TABLE user_roles (
  roleid number(20) NOT NULL,
  userid number(20) NOT NULL,
  constraint pk_user_roles PRIMARY KEY(userid,roleid) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  CONSTRAINT fk_user_roles_userid FOREIGN KEY (userid) REFERENCES users (id),
  CONSTRAINT fk_user_roles_roleid FOREIGN KEY (roleid) REFERENCES roles (id)
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

-- DELIMITER ;

-- mobilefabric_configuration;
CREATE TABLE mobilefabric_configuration (
  id               number(20)        NOT NULL ,
  prop_name varchar2(255) NOT NULL,
  prop_value varchar2(255) NOT NULL,
  prop_type varchar2(1000) DEFAULT NULL,
  col1 varchar2(255) DEFAULT NULL ,
  col2 varchar2(255) DEFAULT NULL,
  col3 varchar2(255) DEFAULT NULL,
  col4 varchar2(255) DEFAULT NULL,
  col5 varchar2(255) DEFAULT NULL,
  created_by         varchar2(255) DEFAULT NULL,    
  created_date         DATE DEFAULT NULL,    
  updated_by         varchar2(255) DEFAULT NULL,
  updated_date         DATE DEFAULT NULL,
  constraint pk_mobilefabric_configuration PRIMARY KEY(id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  constraint uk_configuration_name unique(prop_name) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_mobilefabric_configuration
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;

-- DELIMITER /

CREATE OR REPLACE TRIGGER TRG_mobilefabric_configuration BEFORE INSERT ON mobilefabric_configuration
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select SEQ_mobilefabric_configuration.nextval into :new.id from dual;
   END IF;

END;
/

-- DELIMITER ;

-- mobilefabric_environment;
CREATE TABLE mobilefabric_environment (
    id number(20) NOT NULL ,
    environment_guid varchar2(40) DEFAULT NULL,
    mobile_fabric_version varchar2(255) DEFAULT NULL,
    account_guid  varchar2(40) DEFAULT NULL,
    account_id number(20) DEFAULT NULL,    
    environment_name varchar2(255) DEFAULT NULL,     
    environment_service_url  varchar2(255) DEFAULT NULL,
    account_auth_url  varchar2(255) DEFAULT NULL ,
    environment_auth_url  varchar2(255) DEFAULT NULL,
    account_api_base_url varchar2(255) DEFAULT NULL,
    account_ui_base_url varchar2(255) DEFAULT NULL,
    col1 varchar2(255) DEFAULT NULL ,
    col2 varchar2(255) DEFAULT NULL,
    col3 varchar2(255) DEFAULT NULL,
    col4 varchar2(255) DEFAULT NULL,
    col5 varchar2(255) DEFAULT NULL,
    created_by         varchar2(255) DEFAULT NULL,    
    created_date         DATE DEFAULT NULL,    
    updated_by         varchar2(255) DEFAULT NULL,
    updated_date         DATE DEFAULT NULL,
  constraint pk_mobilefabric_environment PRIMARY KEY(id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  constraint uk_environment_guid unique(environment_guid) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_mobilefabric_environment
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;

-- DELIMITER /  

CREATE OR REPLACE TRIGGER TRG_mobilefabric_environment BEFORE INSERT ON mobilefabric_environment
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN 
      select SEQ_mobilefabric_environment.nextval into :new.id from dual;
   END IF;

END;
/

-- DELIMITER ;

-- app_war_info;
CREATE TABLE app_war_info (
  app_war_id number(20) NOT NULL ,
  created_date date DEFAULT NULL,
  created_by varchar2(255) DEFAULT NULL,
  updated_date date DEFAULT NULL,
  updated_by varchar2(255) DEFAULT NULL,
  war_name varchar2(255) DEFAULT NULL,
  col1 varchar2(255) DEFAULT NULL ,
  col2 varchar2(255) DEFAULT NULL,
  col3 varchar2(255) DEFAULT NULL,
  col4 varchar2(255) DEFAULT NULL,
  col5 varchar2(255) DEFAULT NULL,
  war_content blob,
  constraint pk_app_war_info PRIMARY KEY(app_war_id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  constraint uk_war_name unique(war_name) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) LOB (war_content) store as LOB_app_war_info ( tablespace ${KONY_SERVER_LOB_TABLESPACE} ) 
tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_app_war_info
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;
  
-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_app_war_info BEFORE INSERT ON app_war_info
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.app_war_id IS NULL THEN
      select SEQ_app_war_info.nextval into :new.app_war_id from dual;
   END IF;

END;
/

-- DELIMITER ;

-- app_info;
CREATE TABLE app_info (
    app_id number(20) NOT NULL ,
    app_content blob,
     app_name varchar2(255) NOT NULL,
     application_guid varchar2(255) DEFAULT NULL,
      application_description varchar2(255) DEFAULT NULL,
      app_war_id number(20) DEFAULT NULL,
      application_id varchar2(255) DEFAULT NULL,
      app_status varchar2(255) DEFAULT NULL,
     col1 varchar2(255) DEFAULT NULL ,
    col2 varchar2(255) DEFAULT NULL,
    col3 varchar2(255) DEFAULT NULL,
    col4 varchar2(255) DEFAULT NULL,
    col5 varchar2(255) DEFAULT NULL,
    created_by         varchar2(255) DEFAULT NULL,    
    created_date         DATE DEFAULT NULL,    
    updated_by         varchar2(255) DEFAULT NULL,
    updated_date         DATE DEFAULT NULL,
  constraint pk_app_info PRIMARY KEY(app_id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  constraint uk_app_name unique(app_name) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  CONSTRAINT fk_app_war_id FOREIGN KEY (app_war_id) REFERENCES app_war_info (app_war_id)
)LOB (app_content) store as LOB_app_info ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
 tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_app_info
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;
  
-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_app_info BEFORE INSERT ON app_info
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.app_id IS NULL THEN    
      select SEQ_app_info.nextval into :new.app_id from dual;
   END IF;

END;
/


-- DELIMITER ;

-- jar_info;
 CREATE TABLE jar_info (
      jar_id number(20) NOT NULL ,
      jar_content blob,
      jar_name varchar2(255) DEFAULT NULL,
      col1 varchar2(255) DEFAULT NULL ,
    col2 varchar2(255) DEFAULT NULL,
    col3 varchar2(255) DEFAULT NULL,
    col4 varchar2(255) DEFAULT NULL,
    col5 varchar2(255) DEFAULT NULL,
    created_by         varchar2(255) DEFAULT NULL,    
    created_date         DATE DEFAULT NULL,    
    updated_by         varchar2(255) DEFAULT NULL,
    updated_date         DATE DEFAULT NULL,
  constraint pk_jar_info PRIMARY KEY(jar_id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  constraint uk_jar_name unique(jar_name) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) LOB (jar_content) store as LOB_jar_info ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_jar_info
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;
  
-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_jar_info BEFORE INSERT ON jar_info
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.jar_id IS NULL THEN
      select SEQ_jar_info.nextval into :new.jar_id from dual;
   END IF;

END;
/

-- DELIMITER ;
	
-- app_jar_info;
CREATE TABLE app_jar_info (
  app_id number(20) NOT NULL,
  jar_id number(20) NOT NULL,
  CONSTRAINT fk_app_jar_info_jar_id FOREIGN KEY (jar_id) REFERENCES jar_info (jar_id),
  CONSTRAINT fk_app_jar_info_app_id FOREIGN KEY (app_id) REFERENCES app_info (app_id)
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE TABLE build_version (
   	build_version varchar2(255) DEFAULT NULL ,
	build_date 	DATE DEFAULT NULL	
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

-- DELIMITER ;
-- INSERT INTO build_version(build_version, build_date) values ('#SERVER_BUILD_VERSION#', to_date(sysdate,'yyyy-mm-dd hh24:mi:ss'));

-- Inser statements to insert required data
-- insert into roles
INSERT INTO roles(id, description, name, display_name) VALUES (1,'Represents the system administrator','ROLE_ADMIN', 'Admin');
INSERT INTO roles(id, description, name, display_name) VALUES (2,'Represents the report viewer who uses application for report viewing','ROLE_REPORT_VIEWER', 'Report Viewer');
INSERT INTO roles(id, description, name, display_name) VALUES (3,'Represents the end user who publish the application','ROLE_PUBLISHER', 'Publisher');

-- insert into users
INSERT INTO users(id, userId, name, password, mobile, email, deleted, enabled, created_by, updated_by, created_date, updated_date) VALUES (1,'admin','Administrator','240be518fabd2724ddb6f04eeb1da5967448d7e831c08c8fa822809f74c720a9','1234567890','admin@kony.com',0, 1,'admin','admin', sysdate, sysdate);
INSERT INTO users(id, userId, name, password, mobile, email, deleted, enabled, created_by, updated_by, created_date, updated_date) VALUES (2,'mobilefabricadmin','MobileFabric Administrator','1afc111ca0e435623faca0e5ab5a27d69547f1cfa1a6e4ff99cea31a2cc37674','1234567890','mobilefabricadmin@kony.com',0, 1,'mobilefabricadmin','mobilefabricadmin', sysdate, sysdate);

-- insert into user_roles
INSERT INTO user_roles(userid, roleid) VALUES (1,1);
INSERT INTO user_roles(userid, roleid) VALUES (2,1);

commit;

-- DELIMITER /

DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(id),0) into max_id from roles; select '1' into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_roles.nextval INTO cur_seq FROM dual; END LOOP; END;
/

DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(id),0) into max_id from users; select '1' into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_users.nextval INTO cur_seq FROM dual; END LOOP; END;
/

-- DELIMITER ;
commit;