CREATE TABLE SERVER_JOB (
  JOB_ID number(20) NOT NULL ,
  JOB_NAME varchar2(100) NOT NULL,
  JOB_DESCRIPTION varchar2(255) NULL,
  JOB_FREQUENCY varchar2(255) NOT NULL,
  JOB_SERVICE_TYPE varchar2(100) NOT NULL,
  JOB_SOURCE_TYPE varchar2(100) NOT NULL,
  JOB_INFO clob NULL,
  JOB_FREQUENCY_INFO clob NULL,
  JOB_RUNAT varchar2(100) NOT NULL,
  JOB_NODE varchar2(100) NOT NULL,
  JOB_STORE_TYPE varchar2(100) NOT NULL,
  JOB_MODE varchar2(100) NOT NULL,
  JOB_HISTORY varchar2(100) NOT NULL,
  JOB_HISTORY_RETENTION_PERIOD varchar2(100) NULL,
  JOB_SUCCESS_CRITERIA varchar2(255) NULL,
  JOB_ACTIVE char(1) NOT NULL,
  CREATED_BY varchar2(255) NULL,
  CREATED_DATE DATE NULL,
  UPDATED_BY varchar2(255) NULL,
  UPDATED_DATE DATE NULL,
  constraint PK_SERVER_JOB PRIMARY KEY(JOB_ID) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  constraint UK_SERVER_JOB UNIQUE(JOB_NAME) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) LOB (JOB_INFO) store as LOB_JOB_INFO ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
  LOB (JOB_FREQUENCY_INFO) store as LOB_JOB_FREQUENCY_INFO ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_SERVER_JOB
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;  

CREATE OR REPLACE TRIGGER SERVER_JOB_TRG BEFORE INSERT ON SERVER_JOB
FOR EACH ROW
DECLARE 
max_id number;
cur_seq number;
BEGIN
  IF INSERTING AND :new.JOB_ID IS NULL THEN
    SELECT  SEQ_SERVER_JOB.NEXTVAL INTO :new.JOB_ID FROM DUAL;
    else 
      SELECT greatest(NVL(max(JOB_ID),0), :new.JOB_ID) into max_id from SERVER_JOB;
      select SEQ_SERVER_JOB.nextval into cur_seq from dual; while cur_seq < max_id
      LOOP
           
           SELECT SEQ_SERVER_JOB.nextval INTO cur_seq FROM dual;
      END LOOP;
  	END IF;
END;  	
/

CREATE TABLE SERVER_JOB_HISTORY (
  JOB_RUN_ID number(20) NOT NULL,
  JOB_ID number(20) NOT NULL ,
  JOB_START_TIME DATE NULL,
  JOB_END_TIME DATE NULL,
  JOB_RUN_REQUEST_HEADER clob NULL,
  JOB_RUN_REQUEST clob NULL,
  JOB_RUN_RESPONSE_HEADER clob NULL,
  JOB_RUN_RESPONSE clob NULL,
  JOB_FREQUENCY varchar2(255) NULL,
  JOB_STATUS varchar2(100) NULL,
  CREATED_BY varchar2(255) NULL,
  CREATED_DATE DATE NULL,
  UPDATED_BY varchar2(255) NULL,
  UPDATED_DATE DATE NULL,
  CONSTRAINT PK_SERVER_JOB_HISTORY_ID PRIMARY KEY(JOB_RUN_ID) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  CONSTRAINT FK_SERVER_JOB_HISTORY_JOB_ID FOREIGN KEY (JOB_ID) REFERENCES SERVER_JOB (JOB_ID)
  ) LOB (JOB_RUN_REQUEST_HEADER) store as LOB_JOB_RUN_REQUEST_HEADER ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
    LOB (JOB_RUN_REQUEST) store as LOB_JOB_RUN_REQUEST ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
    LOB (JOB_RUN_RESPONSE_HEADER) store as LOB_JOB_RUN_RESPONSE_HEADER ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
    LOB (JOB_RUN_RESPONSE) store as LOB_JOB_RUN_RESPONSE ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
  tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_SERVER_JOB_HISTORY
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20; 
  
  
CREATE OR REPLACE TRIGGER TRG_SERVER_JOB_HISTORY BEFORE INSERT ON SERVER_JOB_HISTORY
FOR EACH ROW
DECLARE 
max_id number;
cur_seq number;
BEGIN
  IF INSERTING AND :new.JOB_RUN_ID IS NULL THEN
    SELECT  SEQ_SERVER_JOB_HISTORY.NEXTVAL INTO :new.JOB_RUN_ID FROM DUAL;
    else 
      SELECT greatest(NVL(max(JOB_RUN_ID),0), :new.JOB_RUN_ID) into max_id from SERVER_JOB_HISTORY;
      select SEQ_SERVER_JOB_HISTORY.nextval into cur_seq from dual; while cur_seq < max_id
      LOOP
           
           SELECT SEQ_SERVER_JOB_HISTORY.nextval INTO cur_seq FROM dual;
      END LOOP;
  	END IF;
END;  	
/  
  
CREATE TABLE server_qz_job_details (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    JOB_NAME  VARCHAR2(200) NOT NULL,
    JOB_GROUP VARCHAR2(200) NOT NULL,
    DESCRIPTION VARCHAR2(250) NULL,
    JOB_CLASS_NAME   VARCHAR2(250) NOT NULL, 
    IS_DURABLE VARCHAR2(1) NOT NULL,
    IS_NONCONCURRENT VARCHAR2(1) NOT NULL,
    IS_UPDATE_DATA VARCHAR2(1) NOT NULL,
    REQUESTS_RECOVERY VARCHAR2(1) NOT NULL,
    JOB_DATA BLOB NULL,
    CONSTRAINT SERVER_QZ_JOB_DETAILS_PK PRIMARY KEY (SCHED_NAME,JOB_NAME,JOB_GROUP) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) LOB (JOB_DATA) store as LOB_JOB_DATA ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE TABLE server_qz_triggers (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    JOB_NAME  VARCHAR2(200) NOT NULL, 
    JOB_GROUP VARCHAR2(200) NOT NULL,
    DESCRIPTION VARCHAR2(250) NULL,
    NEXT_FIRE_TIME NUMBER(13) NULL,
    PREV_FIRE_TIME NUMBER(13) NULL,
    PRIORITY NUMBER(13) NULL,
    TRIGGER_STATE VARCHAR2(16) NOT NULL,
    TRIGGER_TYPE VARCHAR2(8) NOT NULL,
    START_TIME NUMBER(13) NOT NULL,
    END_TIME NUMBER(13) NULL,
    CALENDAR_NAME VARCHAR2(200) NULL,
    MISFIRE_INSTR NUMBER(2) NULL,
    JOB_DATA BLOB NULL,
    CONSTRAINT SERVER_QZ_TRIGGERS_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
    CONSTRAINT SERVER_QZ_TRIGGER_TO_JOBS_FK FOREIGN KEY (SCHED_NAME,JOB_NAME,JOB_GROUP) 
      REFERENCES SERVER_QZ_JOB_DETAILS(SCHED_NAME,JOB_NAME,JOB_GROUP) 
) LOB (JOB_DATA) store as LOB_TRIG_JOB_DATA ( tablespace ${KONY_SERVER_LOB_TABLESPACE} ) 
tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE TABLE server_qz_simple_triggers (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    REPEAT_COUNT NUMBER(7) NOT NULL,
    REPEAT_INTERVAL NUMBER(12) NOT NULL,
    TIMES_TRIGGERED NUMBER(10) NOT NULL,
    CONSTRAINT SERVER_QZ_SIMPLE_TRIG_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
    CONSTRAINT SERVER_QZ_SIMPLE_TRIG_FK FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) 
	REFERENCES SERVER_QZ_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE TABLE server_qz_cron_triggers (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    CRON_EXPRESSION VARCHAR2(120) NOT NULL,
    TIME_ZONE_ID VARCHAR2(80),
    CONSTRAINT SERVER_QZ_CRON_TRIG_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
    CONSTRAINT SERVER_QZ_CRON_TRIG_FK FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) 
      REFERENCES SERVER_QZ_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE TABLE server_qz_simprop_triggers (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    STR_PROP_1 VARCHAR2(512) NULL,
    STR_PROP_2 VARCHAR2(512) NULL,
    STR_PROP_3 VARCHAR2(512) NULL,
    INT_PROP_1 NUMBER(10) NULL,
    INT_PROP_2 NUMBER(10) NULL,
    LONG_PROP_1 NUMBER(13) NULL,
    LONG_PROP_2 NUMBER(13) NULL,
    DEC_PROP_1 NUMERIC(13,4) NULL,
    DEC_PROP_2 NUMERIC(13,4) NULL,
    BOOL_PROP_1 VARCHAR2(1) NULL,
    BOOL_PROP_2 VARCHAR2(1) NULL,
    CONSTRAINT SERVER_QZ_SIMPROP_TRIG_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
    CONSTRAINT SERVER_QZ_SIMPROP_TRIG_FK FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) 
      REFERENCES SERVER_QZ_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE TABLE server_qz_blob_triggers (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    BLOB_DATA BLOB NULL,
    CONSTRAINT SERVER_QZ_BLOB_TRIG_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
    CONSTRAINT SERVER_QZ_BLOB_TRIG_FK FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) 
        REFERENCES SERVER_QZ_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
) LOB (BLOB_DATA) store as LOB_BLOB_DATA ( tablespace ${KONY_SERVER_LOB_TABLESPACE} ) 
tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE TABLE server_qz_calendars (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    CALENDAR_NAME  VARCHAR2(200) NOT NULL, 
    CALENDAR BLOB NOT NULL,
    CONSTRAINT SERVER_QZ_CALENDARS_PK PRIMARY KEY (SCHED_NAME,CALENDAR_NAME) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) LOB (CALENDAR) store as LOB_CALENDAR ( tablespace ${KONY_SERVER_LOB_TABLESPACE} ) 
tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE TABLE server_qz_paused_trigger_grps (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_GROUP  VARCHAR2(200) NOT NULL, 
    CONSTRAINT SERVER_QZ_PAUSED_TRIG_GRPS_PK PRIMARY KEY (SCHED_NAME,TRIGGER_GROUP) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE TABLE server_qz_fired_triggers (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    ENTRY_ID VARCHAR2(95) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    INSTANCE_NAME VARCHAR2(200) NOT NULL,
    FIRED_TIME NUMBER(13) NOT NULL,
    SCHED_TIME NUMBER(13) NOT NULL,
    PRIORITY NUMBER(13) NOT NULL,
    STATE VARCHAR2(16) NOT NULL,
    JOB_NAME VARCHAR2(200) NULL,
    JOB_GROUP VARCHAR2(200) NULL,
    IS_NONCONCURRENT VARCHAR2(1) NULL,
    REQUESTS_RECOVERY VARCHAR2(1) NULL,
    CONSTRAINT SERVER_QZ_FIRED_TRIGGER_PK PRIMARY KEY (SCHED_NAME,ENTRY_ID) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE TABLE server_qz_scheduler_state (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    INSTANCE_NAME VARCHAR2(200) NOT NULL,
    LAST_CHECKIN_TIME NUMBER(13) NOT NULL,
    CHECKIN_INTERVAL NUMBER(13) NOT NULL,
    CONSTRAINT SERVER_QZ_SCHEDULER_STATE_PK PRIMARY KEY (SCHED_NAME,INSTANCE_NAME) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE TABLE server_qz_locks (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    LOCK_NAME  VARCHAR2(40) NOT NULL, 
    CONSTRAINT SERVER_QZ_LOCKS_PK PRIMARY KEY (SCHED_NAME,LOCK_NAME) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

create index idx_server_qz_j_req_recovery on server_qz_job_details(SCHED_NAME,REQUESTS_RECOVERY);
create index idx_server_qz_j_grp on server_qz_job_details(SCHED_NAME,JOB_GROUP);

create index idx_server_qz_t_j on server_qz_triggers(SCHED_NAME,JOB_NAME,JOB_GROUP);
create index idx_server_qz_t_jg on server_qz_triggers(SCHED_NAME,JOB_GROUP);
create index idx_server_qz_t_c on server_qz_triggers(SCHED_NAME,CALENDAR_NAME);
create index idx_server_qz_t_g on server_qz_triggers(SCHED_NAME,TRIGGER_GROUP);
create index idx_server_qz_t_state on server_qz_triggers(SCHED_NAME,TRIGGER_STATE);
create index idx_server_qz_t_n_state on server_qz_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_STATE);
create index idx_server_qz_t_n_g_state on server_qz_triggers(SCHED_NAME,TRIGGER_GROUP,TRIGGER_STATE);
create index idx_server_qz_t_next_fire_time on server_qz_triggers(SCHED_NAME,NEXT_FIRE_TIME);
create index idx_server_qz_t_nft_st on server_qz_triggers(SCHED_NAME,TRIGGER_STATE,NEXT_FIRE_TIME);
create index idx_server_qz_t_nft_misfire on server_qz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME);
create index idx_server_qz_t_nft_st_misfire on server_qz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_STATE);
create index idx_srv_qz_t_nft_st_misfir_grp on server_qz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_GROUP,TRIGGER_STATE);

create index idx_server_qz_ft_trig_ins_name on server_qz_fired_triggers(SCHED_NAME,INSTANCE_NAME);
create index idx_srv_qz_ft_inst_job_req_rry on server_qz_fired_triggers(SCHED_NAME,INSTANCE_NAME,REQUESTS_RECOVERY);
create index idx_server_qz_ft_j_g on server_qz_fired_triggers(SCHED_NAME,JOB_NAME,JOB_GROUP);
create index idx_server_qz_ft_jg on server_qz_fired_triggers(SCHED_NAME,JOB_GROUP);
create index idx_server_qz_ft_t_g on server_qz_fired_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP);
create index idx_server_qz_ft_tg on server_qz_fired_triggers(SCHED_NAME,TRIGGER_GROUP);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.scheduler.skipUpdateCheck', 'true', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.jobStore.dataSource', 'mobileFabricQuartzDS', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.scheduler.instanceId', 'AUTO', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.jobStore.acquireTriggersWithinLock', 'true', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.scheduler.instanceName', 'MobileFabric_Scheduler', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.jobStore.class', 'org.quartz.impl.jdbcjobstore.JobStoreTX', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.threadPool.class', 'org.quartz.simpl.SimpleThreadPool', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.jobStore.driverDelegateClass', 'org.quartz.impl.jdbcjobstore.StdJDBCDelegate', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.jobStore.isClustered', 'false', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.threadPool.threadCount', '5', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.jobStore.useProperties', 'false', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.jobStore.tablePrefix', 'server_qz_', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.jobStore.misfireThreshold', '60000', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'org.quartz.jobStore.selectWithLockSQL', 'SELECT * FROM {0}LOCKS WHERE LOCK_NAME = ? FOR UPDATE', 'MobileFabricJob', SYSDATE, SYSDATE);

insert into server_configuration(id,prop_name, prop_value, prop_type, created_date, updated_date) values(SEQ_server_configuration.NEXTVAL,'SERVER_CLEANUP_JOB_FREQUENCY', '0 0 0 1/1 * ? *', 'MobileFabricJob', SYSDATE, SYSDATE);