CREATE TABLE SERVER_JOB_STATISTICS (
  JOB_STAT_ID number(20) NOT NULL,
  JOB_ID number(20) NOT NULL ,
  TOTAL_RUNS number(20) NOT NULL ,
  SUCCESS_RUNS number(20) NOT NULL ,
  FAILED_RUNS number(20) NOT NULL ,
  LAST_RUN_ELAPSED_TIME number(20) NOT NULL ,
  TOTAL_ELAPSED_TIME number(20) NOT NULL ,
  LAST_RUN_STATUS varchar2(100) NOT NULL,
  CREATED_BY varchar2(255) NULL,
  CREATED_DATE DATE NULL,
  UPDATED_BY varchar2(255) NULL,
  UPDATED_DATE DATE NULL,
  CONSTRAINT PK_SERVER_JOB_STATISTICS_ID PRIMARY KEY(JOB_STAT_ID) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  CONSTRAINT FK_SERVER_JOB_STATISTICS_JOBID FOREIGN KEY (JOB_ID) REFERENCES SERVER_JOB (JOB_ID)
  ) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_SERVER_JOB_STATISTICS
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20; 
  
  
CREATE OR REPLACE TRIGGER TRG_SERVER_JOB_STATISTICS BEFORE INSERT ON SERVER_JOB_STATISTICS
FOR EACH ROW
DECLARE 
max_id number;
cur_seq number;
BEGIN
  IF INSERTING AND :new.JOB_STAT_ID IS NULL THEN
    SELECT  SEQ_SERVER_JOB_STATISTICS.NEXTVAL INTO :new.JOB_STAT_ID FROM DUAL;
    else 
      SELECT greatest(NVL(max(JOB_STAT_ID),0), :new.JOB_STAT_ID) into max_id from SERVER_JOB_STATISTICS;
      select SEQ_SERVER_JOB_STATISTICS.nextval into cur_seq from dual; while cur_seq < max_id
      LOOP
           
           SELECT SEQ_SERVER_JOB_STATISTICS.nextval INTO cur_seq FROM dual;
      END LOOP;
  	END IF;
END;  	
/