CREATE TABLE server_client_asset_info (
  client_asset_id number(20) NOT NULL ,
  client_asset_content blob NULL,
  client_asset_name varchar2(50) ,
  client_asset_type varchar2(50) ,
  client_asset_parent_type varchar2(50) ,
  client_asset_description varchar2(50) ,
  col1 varchar2(50) ,
  col2 varchar2(50) ,
  col3 varchar2(50) ,
  col4 varchar2(50) ,
  col5 varchar2(50) ,
  created_by varchar2(50) ,
  created_date DATE ,
  updated_by varchar2(50) ,
  updated_date DATE ,
  constraint pk_client_asset_info PRIMARY KEY(client_asset_id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
  ) LOB (client_asset_content) store as LOB_client_asset_info ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
  tablespace ${KONY_SERVER_DATA_TABLESPACE};
  
CREATE TABLE server_app_client_asset_info (
  app_id number(20) NOT NULL,
  client_asset_id number(20) NOT NULL,
  CONSTRAINT fk_client_asset_info_id FOREIGN KEY (client_asset_id) REFERENCES server_client_asset_info (client_asset_id),
  CONSTRAINT fk_app_info_client_asset FOREIGN KEY (app_id) REFERENCES app_info (app_id)
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_client_asset_info
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;
  
CREATE OR REPLACE TRIGGER TRG_client_asset_info BEFORE INSERT ON SERVER_CLIENT_ASSET_INFO
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.client_asset_id IS NULL THEN    
      select SEQ_client_asset_info.nextval into :new.client_asset_id from dual;
   END IF;

END;
/