CREATE TABLE server_log_devicerequestdata (
  request_id varchar2(50) NOT NULL,
  app_id varchar2(50),  
  device_id varchar2(255),
  user_id VARCHAR(128),
  created_by varchar2(255) ,
  created_date DATE ,
  updated_by varchar2(255) ,
  updated_date DATE ,
  request_method varchar2(50),
  event_date DATE,
  payload  blob,
  request_size number,
  CONSTRAINT pk_request_id PRIMARY KEY(request_id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
  ) LOB (payload) store as lob_payload_dresd ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
  tablespace ${KONY_SERVER_DATA_TABLESPACE};
  
  
CREATE TABLE server_log_deviceresponsedata (
  request_id varchar2(50) NOT NULL,
  created_by varchar2(255) ,
  created_date DATE ,
  updated_by varchar2(255) ,
  updated_date DATE ,
   opstatus number(7),
   event_date DATE,
   payload  blob,
   response_size number,
   CONSTRAINT fk_log_responseData FOREIGN KEY (request_id) REFERENCES server_log_devicerequestdata (request_id)
   ) LOB (payload) store as lob_payload_dreqd ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
   tablespace ${KONY_SERVER_DATA_TABLESPACE};

  
 CREATE TABLE server_log_events (
   request_id varchar2(50) NOT NULL,
   created_by varchar2(255) ,
  created_date DATE ,
  updated_by varchar2(255) ,
  updated_date DATE ,
  event_type varchar2(50),
   payload  blob,
   CONSTRAINT fk_log_datasource FOREIGN KEY (request_id) REFERENCES server_log_devicerequestdata (request_id)
   )LOB (payload) store as lob_payload_ds_ ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
   tablespace ${KONY_SERVER_DATA_TABLESPACE};
   
   insert into server_configuration(id,prop_name, prop_value, created_date , updated_date) values(SEQ_server_configuration.NEXTVAL,'KONY_SERVER_TRACELOGS_LEVEL','OFF', SYSDATE,SYSDATE);
