CREATE TABLE server_timer_metrics (
	service_name varchar2(255) NOT NULL,
	service_version varchar2(25) NOT NULL,
	parent_service_name varchar2(255),
	operation_name varchar2(255) NOT NULL,
	service_category varchar2(35) NOT NULL,
	service_type varchar2(35) NOT NULL,
	verb varchar2(25) NOT NULL,
	instance_id varchar2(35) NOT NULL,
	count integer,
	service_min number(9,3),
	service_max number(9,3),
	service_mean number(9,3),
	service_stddev number(9,3),
	pre_processor_min number(9,3),
	pre_processor_max number(9,3),
	pre_processor_mean number(9,3),
	pre_processor_stddev number(9,3),
	post_processor_min number(9,3),
	post_processor_max number(9,3),
	post_processor_mean number(9,3),
	post_processor_stddev number(9,3),
	request_mapper_min number(9,3),
	request_mapper_max number(9,3),
	request_mapper_mean number(9,3),
	request_mapper_stddev number(9,3),
	response_mapper_min number(9,3),
	response_mapper_max number(9,3),
	response_mapper_mean number(9,3),
	response_mapper_stddev number(9,3),
	backend_request_min number(9,3),
	backend_request_max number(9,3),
	backend_request_mean number(9,3),
	backend_request_stddev number(9,3),
	parsing_min number(9,3),
	parsing_max number(9,3),
	parsing_mean number(9,3),
	parsing_stddev number(9,3),
	url_provider_processing_min number(9,3),
	url_provider_processing_max number(9,3),
	url_provider_processing_mean number(9,3),
	url_provider_processing_stddev number(9,3),
	timestamp TIMESTAMP 
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

create index idx_servermetrics_inst_id on server_timer_metrics(instance_id) tablespace ${KONY_SERVER_INDEX_TABLESPACE};
create index idx_servermetrics_ts on server_timer_metrics(timestamp) tablespace ${KONY_SERVER_INDEX_TABLESPACE};
