DROP TABLE server_timer_metrics purge;

CREATE TABLE server_timer_metrics (
	service_name varchar2(255) NOT NULL,
	service_version varchar2(25) NOT NULL,
	parent_service_name varchar2(255),
	operation_name varchar2(255) NOT NULL,
	service_category varchar2(35) NOT NULL,
	service_type varchar2(35) NOT NULL,
	verb varchar2(25) NOT NULL,
	instance_id varchar2(35) NOT NULL,
	count integer,
	service_min integer,
	service_max integer,
	service_mean integer,
	service_stddev integer,
	pre_processor_min integer,
	pre_processor_max integer,
	pre_processor_mean integer,
	pre_processor_stddev integer,
	post_processor_min integer,
	post_processor_max integer,
	post_processor_mean integer,
	post_processor_stddev integer,
	request_mapper_min integer,
	request_mapper_max integer,
	request_mapper_mean integer,
	request_mapper_stddev integer,
	response_mapper_min integer,
	response_mapper_max integer,
	response_mapper_mean integer,
	response_mapper_stddev integer,
	backend_request_min integer,
	backend_request_max integer,
	backend_request_mean integer,
	backend_request_stddev integer,
	parsing_min integer,
	parsing_max integer,
	parsing_mean integer,
	parsing_stddev integer,
	url_provider_processing_min integer,
	url_provider_processing_max integer,
	url_provider_processing_mean integer,
	url_provider_processing_stddev integer,
	timestamp TIMESTAMP 
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

create index idx_servermetrics_inst_id on server_timer_metrics(instance_id) tablespace ${KONY_SERVER_INDEX_TABLESPACE};
create index idx_servermetrics_ts on server_timer_metrics(timestamp) tablespace ${KONY_SERVER_INDEX_TABLESPACE};
