DROP TRIGGER trg_upload_cache_id;
DROP SEQUENCE SEQ_upload_cache_id;
DROP TABLE upload_cache;

CREATE TABLE upload_cache (
  id NUMBER(20),
  req_hash varchar2(50) NOT NULL,
  response BLOB ,
  iserror smallint default 0 NOT NULL ,
  firsthittime NUMBER(20) NOT NULL,
  created_date timestamp(6),
  updated_date timestamp(6),
  updated_by varchar2(50),
  created_by varchar2(50),
  constraint  pk_upload_cache_id PRIMARY KEY(id) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  constraint uk_upload_cache_req_hash unique(req_hash) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) LOB (response) store as upload_cache ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
tablespace ${KONY_SERVER_DATA_TABLESPACE};

 CREATE SEQUENCE SEQ_upload_cache_id
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;


CREATE OR REPLACE TRIGGER trg_upload_cache_id BEFORE INSERT ON upload_cache
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select SEQ_upload_cache_id.nextval into :new.id from dual;
   END IF;

END;
/