CREATE TABLE server_certs_table (
  id NUMBER(20),
  alias CLOB NOT NULL,
  certificate_content blob,
  certificate_file_name varchar2(255) NOT NULL,
  keypass CLOB,
  discriminator varchar2(1) NOT NULL,
  privatekey_content blob,
  privatekey_file_name varchar2(255),
  privatekey_password CLOB,
  domain CLOB ,
  created_date timestamp,
  updated_date timestamp,
  updated_by varchar2(50),
  created_by varchar2(50),
  constraint  pk_server_certs_table_id PRIMARY KEY(id) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) 
LOB (alias) store as clob_s_certs_table_alias ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )

LOB (certificate_content) store as blob_s_certs_table_cert_cntnt ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )

LOB (keypass) store as clob_s_certs_table_keypass ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )

LOB (privatekey_content) store as blob_s_certs_table_pk_content ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )

LOB (privatekey_password) store as clob_s_certs_table_pk_pwd ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )

LOB (domain) store as clob_s_certs_table_domain ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )

tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_server_certs_table_id
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;



CREATE OR REPLACE TRIGGER trg_server_certs_table_id BEFORE INSERT ON server_certs_table
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select SEQ_server_certs_table_id.nextval into :new.id from dual;
   END IF;

END;