drop table server_certs_table purge;
CREATE TABLE server_certificate (
  id NUMBER(20),
  cert_alias CLOB NOT NULL,
  target_domains CLOB,
  certificate_content CLOB,
  certificate_file_name varchar2(255) NOT NULL,
  keypass CLOB,
  discriminator varchar2(1) NOT NULL,
  privatekey_content CLOB,
  privatekey_file_name varchar2(255),
  privatekey_password CLOB,
  privatekey_algo varchar2(255),
  created_date timestamp,
  updated_date timestamp,
  updated_by varchar2(50),
  created_by varchar2(50),
  constraint  pk_server_certs_table_id PRIMARY KEY(id) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) 
LOB (cert_alias) store as clob_s_certs_table_alias ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )

LOB (certificate_content) store as clob_s_certs_table_cert_cntnt ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )

LOB (keypass) store as clob_s_certs_table_keypass ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )

LOB (privatekey_content) store as clob_s_certs_table_pk_content ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )

LOB (privatekey_password) store as clob_s_certs_table_pk_pwd ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )

LOB (target_domains) store as clob_s_certs_table_domain ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )

tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_server_cert_id
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;



CREATE OR REPLACE TRIGGER trg_server_certs_id BEFORE INSERT ON server_certificate
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select SEQ_server_cert_id.nextval into :new.id from dual;
   END IF;

END;