alter table upload_cache modify created_date timestamp(6) DEFAULT CURRENT_TIMESTAMP;

CREATE TABLE upload_cache1 (
  id NUMBER(20),
  req_hash varchar2(50) NOT NULL,
  response BLOB ,
  iserror smallint default 0 NOT NULL ,
  firsthittime NUMBER(20) NOT NULL,
  created_date timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  updated_date timestamp(6),
  updated_by varchar2(50),
  created_by varchar2(50),
  constraint  pk_upload_cache1_id PRIMARY KEY(id) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  constraint uk_upload_cache1_req_hash unique(req_hash) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) LOB (response) store as upload_cache1 ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
tablespace ${KONY_SERVER_DATA_TABLESPACE};

 CREATE SEQUENCE SEQ_upload_cache1_id
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;


CREATE OR REPLACE TRIGGER trg_upload_cache1_id BEFORE INSERT ON upload_cache1
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select SEQ_upload_cache1_id.nextval into :new.id from dual;
   END IF;

END;
/


CREATE TABLE upload_cache2 (
  id NUMBER(20),
  req_hash varchar2(50) NOT NULL,
  response BLOB ,
  iserror smallint default 0 NOT NULL ,
  firsthittime NUMBER(20) NOT NULL,
  created_date timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  updated_date timestamp(6),
  updated_by varchar2(50),
  created_by varchar2(50),
  constraint  pk_upload_cache2_id PRIMARY KEY(id) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE},
  constraint uk_upload_cache2_req_hash unique(req_hash) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) LOB (response) store as upload_cache2 ( tablespace ${KONY_SERVER_LOB_TABLESPACE} )
tablespace ${KONY_SERVER_DATA_TABLESPACE};

 CREATE SEQUENCE SEQ_upload_cache2_id
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;


CREATE OR REPLACE TRIGGER trg_upload_cache2_id BEFORE INSERT ON upload_cache2
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select SEQ_upload_cache2_id.nextval into :new.id from dual;
   END IF;

END;
/

CREATE VIEW upload_cache_view AS
   SELECT
	        id, req_hash, response, iserror, firsthittime
	    FROM
	        upload_cache
	    UNION all SELECT
	        id, req_hash, response, iserror, firsthittime
	    FROM
	        upload_cache1
	    UNION all  SELECT
	        id, req_hash, response, iserror, firsthittime
	    FROM
	        upload_cache2;