CREATE TABLE tmp_app_jar_info AS SELECT * FROM app_jar_info;
DELETE FROM app_jar_info;
ALTER TABLE app_jar_info ADD id number(20) NOT NULL;
ALTER TABLE app_jar_info ADD CONSTRAINT pk_app_jar_info PRIMARY KEY(id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE};

CREATE SEQUENCE seq_app_jar_info START WITH 1 INCREMENT BY 1;

CREATE OR REPLACE TRIGGER trg_app_jar_info BEFORE INSERT ON app_jar_info
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select seq_app_jar_info.nextval into :new.id from dual;
   END IF;

END;
/

INSERT INTO app_jar_info(app_id,jar_id) SELECT app_id,jar_id FROM tmp_app_jar_info;
DROP TABLE tmp_app_jar_info purge;


CREATE TABLE tmp_app_asset_info AS SELECT * FROM app_asset_info;
DELETE FROM app_asset_info;
ALTER TABLE app_asset_info ADD id number(20) NOT NULL;
ALTER TABLE app_asset_info ADD CONSTRAINT pk_app_asset_info PRIMARY KEY(id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE};

CREATE SEQUENCE seq_app_asset_info START WITH 1 INCREMENT BY 1;

CREATE OR REPLACE TRIGGER trg_app_asset_info BEFORE INSERT ON app_asset_info
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select seq_app_asset_info.nextval into :new.id from dual;
   END IF;

END;
/

INSERT INTO app_asset_info(app_id,asset_id) SELECT app_id,asset_id FROM tmp_app_asset_info;
DROP TABLE tmp_app_asset_info purge;

COMMIT;