CREATE TABLE server_node_notifier (
  id NUMBER(20) NOT NULL,
  process_id NUMBER(20) NOT NULL,
  action varchar2(50) NOT NULL,
  status varchar2(50),
  status_details varchar2(255),
  created_by varchar2(50),
  created_date timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  updated_by varchar2(50),
  updated_date timestamp(6),
  constraint  pk_notification_id PRIMARY KEY(id) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_node_notifier_id
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;


CREATE OR REPLACE TRIGGER trg_node_notifier_id BEFORE INSERT ON server_node_notifier
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select SEQ_node_notifier_id.nextval into :new.id from dual;
   END IF;

END;
/

CREATE TABLE server_node_status (
  id NUMBER(20) NOT NULL,
  node_id varchar2(50) NOT NULL,
  node_status varchar2(50) NOT NULL,
  process_id NUMBER(20),
  process_action varchar2(50),
  process_status varchar2(50),
  err_msg varchar2(255),
  health_acknowledge NUMBER(20),
  publish_timer_disabled smallint default 0,
  created_by varchar2(50),
  created_date timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  updated_by varchar2(50),
  updated_date timestamp(6),
  constraint  pk_status_id PRIMARY KEY(id) using INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
) tablespace ${KONY_SERVER_DATA_TABLESPACE};

CREATE SEQUENCE SEQ_node_status_id
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;


CREATE OR REPLACE TRIGGER trg_node_status_id BEFORE INSERT ON server_node_status
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select SEQ_node_status_id.nextval into :new.id from dual;
   END IF;

END;
/