SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [asset_info](
	[asset_id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[asset_content] [image] ,
	[asset_name] [varchar](255) ,
	[asset_type] [varchar](255) ,
	[asset_description] [varchar](255) ,
	[col1] [varchar](255) ,
	[col2] [varchar](255) ,
	[col3] [varchar](255) ,
	[col4] [varchar](255) ,
	[col5] [varchar](255) ,
	[created_by] [varchar](255) ,	
	[created_date] [datetime] ,
	[updated_by] [varchar](255) ,
	[updated_date] [datetime] ,	
PRIMARY KEY CLUSTERED 
(
	[asset_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [app_asset_info](
	[app_id] [numeric](19, 0) NOT NULL,
	[asset_id] [numeric](19, 0) NOT NULL,
  CONSTRAINT fk_asset_info_id FOREIGN KEY (asset_id) REFERENCES asset_info (asset_id),
  CONSTRAINT fk_app_info_app_id FOREIGN KEY (app_id) REFERENCES app_info (app_id)
) 
GO

SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [process_info] (
  [process_id] [bigint] NOT NULL IDENTITY(1,1),
  [process_guid] [varchar](255) NULL,
  [process_status] [varchar](255) NULL,
  [current_status] [varchar](255) NULL,
  [col1] [varchar](255) ,
  [col2] [varchar](255) ,
  [col3] [varchar](255) ,
  [col4] [varchar](255) ,
  [col5] [varchar](255) ,
  [created_date] [datetime] ,
  [created_by] [varchar](255) ,
  [updated_date] [datetime] ,
  [updated_by] [varchar](255) ,
  PRIMARY KEY ([process_id])); 
GO

ALTER TABLE [app_info] 
DROP COLUMN [application_guid];
GO
ALTER TABLE [app_info] 
DROP CONSTRAINT [FK4596D00CAA1BEBA7];
GO
ALTER TABLE [app_info] 
DROP COLUMN [app_war_id];
GO
ALTER TABLE [app_info] ADD [process_id] bigint
GO
ALTER TABLE [app_info] ADD CONSTRAINT fk_app_info_process_id FOREIGN KEY (process_id) REFERENCES process_info (process_id);
GO
ALTER TABLE [app_war_info] ADD [process_id] bigint ;
GO
ALTER TABLE [app_war_info] ADD CONSTRAINT fk_app_war_proces_id FOREIGN KEY (process_id) REFERENCES process_info (process_id);
GO
ALTER TABLE [app_war_info] ADD [app_id] [numeric](19, 0) ;
GO
ALTER TABLE [app_war_info] ADD CONSTRAINT fk_app_war_app_id FOREIGN KEY (app_id) REFERENCES app_info (app_id);
GO