SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [app_war_info](
	[app_war_id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[created_date] [datetime] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[war_name] [varchar](255) NULL,
	[war_content] [image] NULL,
PRIMARY KEY CLUSTERED 
(
	[app_war_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[war_name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [users]    Script Date: 10/14/2014 00:06:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [users](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[created_date] [datetime] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[col1] [varchar](255) NULL,
	[col2] [varchar](255) NULL,
	[col3] [varchar](255) NULL,
	[col4] [varchar](255) NULL,
	[col5] [varchar](255) NULL,
	[deleted] [tinyint] NULL,
	[email] [varchar](255) NULL,
	[enabled] [tinyint] NULL,
	[mobile] [varchar](255) NULL,
	[name] [varchar](255) NULL,
	[password] [varchar](255) NULL,
	[userid] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [roles](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[created_date] [datetime] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[col1] [varchar](255) NULL,
	[col2] [varchar](255) NULL,
	[col3] [varchar](255) NULL,
	[col4] [varchar](255) NULL,
	[col5] [varchar](255) NULL,
	[description] [varchar](255) NULL,
	[display_name] [varchar](255) NULL,
	[name] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO



SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [mobilefabric_environment](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[created_date] [datetime] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[account_api_base_url] [varchar](255) NULL,
	[account_auth_url] [varchar](255) NULL,
	[account_guid] [varchar](255) NULL,
	[account_id] [int] NOT NULL,
	[account_ui_base_url] [varchar](255) NULL,
	[col1] [varchar](255) NULL,
	[col2] [varchar](255) NULL,
	[col3] [varchar](255) NULL,
	[col4] [varchar](255) NULL,
	[col5] [varchar](255) NULL,
	[environment_auth_url] [varchar](255) NULL,
	[environment_guid] [varchar](255) NOT NULL,
	[environment_name] [varchar](255) NULL,
	[environment_service_url] [varchar](255) NULL,
	[mobile_fabric_version] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[environment_guid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [mobilefabric_configuration](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[created_date] [datetime] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[col1] [varchar](255) NULL,
	[col2] [varchar](255) NULL,
	[col3] [varchar](255) NULL,
	[col4] [varchar](255) NULL,
	[col5] [varchar](255) NULL,
	[prop_name] [varchar](255) NULL,
	[prop_type] [varchar](255) NULL,
	[prop_value] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [jar_info](
	[jar_id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[created_date] [datetime] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[jar_content] [image] NULL,
	[jar_name] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[jar_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[jar_name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO



SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [user_roles](
	[userid] [numeric](19, 0) NOT NULL,
	[roleid] [numeric](19, 0) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[userid] ASC,
	[roleid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [app_info](
	[app_id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[created_date] [datetime] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[app_content] [image] NULL,
	[application_guid] [varchar](255) NULL,
	[application_id] [varchar](255) NULL,
	[app_status] [varchar](255) NULL,
	[app_name] [varchar](255) NOT NULL,
	[application_description] [varchar](255) NULL,
	[app_war_id] [numeric](19, 0) NULL,
PRIMARY KEY CLUSTERED 
(
	[app_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[application_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [app_jar_info](
	[app_id] [numeric](19, 0) NOT NULL,
	[jar_id] [numeric](19, 0) NOT NULL
) ON [PRIMARY]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [build_version] (
  	[build_version] [varchar](255) NULL,
	[build_date] [datetime] NULL
)
GO
SET ANSI_PADDING OFF
GO

/****** Object:  ForeignKey [FK73429949A03815A9]    Script Date: 10/14/2014 00:06:00 ******/
ALTER TABLE [user_roles]  WITH CHECK ADD  CONSTRAINT [FK73429949A03815A9] FOREIGN KEY([roleid])
REFERENCES [roles] ([id])
GO
ALTER TABLE [user_roles] CHECK CONSTRAINT [FK73429949A03815A9]
GO
/****** Object:  ForeignKey [FK73429949A58D6B13]    Script Date: 10/14/2014 00:06:00 ******/
ALTER TABLE [user_roles]  WITH CHECK ADD  CONSTRAINT [FK73429949A58D6B13] FOREIGN KEY([userid])
REFERENCES [users] ([id])
GO
ALTER TABLE [user_roles] CHECK CONSTRAINT [FK73429949A58D6B13]
GO
/****** Object:  ForeignKey [FK4596D00CAA1BEBA7]    Script Date: 10/14/2014 00:06:00 ******/
ALTER TABLE [app_info]  WITH CHECK ADD  CONSTRAINT [FK4596D00CAA1BEBA7] FOREIGN KEY([app_war_id])
REFERENCES [app_war_info] ([app_war_id])
GO
ALTER TABLE [app_info] CHECK CONSTRAINT [FK4596D00CAA1BEBA7]
GO
/****** Object:  ForeignKey [FKCA5228B0C5B6D2C6]    Script Date: 10/14/2014 00:06:00 ******/
ALTER TABLE [app_jar_info]  WITH CHECK ADD  CONSTRAINT [FKCA5228B0C5B6D2C6] FOREIGN KEY([jar_id])
REFERENCES [jar_info] ([jar_id])
GO
ALTER TABLE [app_jar_info] CHECK CONSTRAINT [FKCA5228B0C5B6D2C6]
GO
/****** Object:  ForeignKey [FKCA5228B0F4921A06]    Script Date: 10/14/2014 00:06:00 ******/
ALTER TABLE [app_jar_info]  WITH CHECK ADD  CONSTRAINT [FKCA5228B0F4921A06] FOREIGN KEY([app_id])
REFERENCES [app_info] ([app_id])
GO
ALTER TABLE [app_jar_info] CHECK CONSTRAINT [FKCA5228B0F4921A06]
GO

-- Insert statements

INSERT INTO [build_version](build_version, build_date) values ('#SERVER_BUILD_VERSION#', getdate());

SET IDENTITY_INSERT [roles] ON
INSERT [roles] (id, description, name, display_name) VALUES (1, N'Represents the system administrator',N'ROLE_ADMIN', N'admin');
INSERT [roles] (id, description, name, display_name) VALUES (2, N'Represents the report viewer who uses application for report viewing',N'ROLE_REPORT_VIEWER', N'Report Viewer');
INSERT [roles] (id, description, name, display_name) VALUES (3, N'Represents the end user who publish the application',N'ROLE_PUBLISHER', N'Publisher');
SET IDENTITY_INSERT [roles] OFF

SET IDENTITY_INSERT [users] ON
INSERT [users] (id, userId, name, password, mobile, email, deleted, enabled, created_by, updated_by, created_date, updated_date) VALUES (1, N'admin',N'Administrator',N'240be518fabd2724ddb6f04eeb1da5967448d7e831c08c8fa822809f74c720a9',N'1234567890',N'admin@kony.com',0, 1,N'admin','admin', getdate(), getdate());
INSERT [users] (id, userId, name, password, mobile, email, deleted, enabled, created_by, updated_by, created_date, updated_date) VALUES (2, N'mobilefabricadmin',N'MobileFabric Administrator',N'1afc111ca0e435623faca0e5ab5a27d69547f1cfa1a6e4ff99cea31a2cc37674',N'1234567890',N'mobilefabricadmin@kony.com',0, 1,N'mobilefabricadmin','mobilefabricadmin', getdate(), getdate());
SET IDENTITY_INSERT [users] OFF

INSERT [user_roles] ([userid], [roleid]) VALUES (1, 1)
INSERT [user_roles] ([userid], [roleid]) VALUES (2, 1)

GO