SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO

CREATE TABLE [SERVER_JOB] (
  [JOB_ID] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
  [JOB_NAME] [varchar](100) NOT NULL,
  [JOB_DESCRIPTION] [varchar](255) ,
  [JOB_FREQUENCY] [varchar](255) NOT NULL,
  [JOB_SERVICE_TYPE] [varchar](100) NOT NULL,
  [JOB_SOURCE_TYPE] [varchar](100) NOT NULL,
  [JOB_INFO] [varchar](MAX),
  [JOB_FREQUENCY_INFO] [varchar](MAX),
  [JOB_RUNAT] [varchar](100) NOT NULL,
  [JOB_NODE] [varchar](100) NOT NULL,
  [JOB_STORE_TYPE] [varchar](100) NOT NULL,
  [JOB_MODE] [varchar](100) NOT NULL,
  [JOB_HISTORY] [varchar](100) NOT NULL,
  [JOB_HISTORY_RETENTION_PERIOD] [varchar](100) ,
  [JOB_SUCCESS_CRITERIA] [varchar](255) ,
  [JOB_ACTIVE] [char](1) NOT NULL,
  [CREATED_BY] [varchar](255) ,	
  [CREATED_DATE] [datetime] ,
  [UPDATED_BY] [varchar](255) ,
  [UPDATED_DATE] [datetime] ,
  PRIMARY KEY CLUSTERED 
(
	[JOB_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[JOB_NAME] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [SERVER_JOB_HISTORY] (
  [JOB_RUN_ID] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
  [JOB_ID] [numeric](19, 0) NOT NULL ,
  [JOB_START_TIME] [datetime] ,
  [JOB_END_TIME] [datetime] ,
  [JOB_RUN_REQUEST_HEADER] [varchar](MAX),
  [JOB_RUN_REQUEST] [varchar](MAX),
  [JOB_RUN_RESPONSE_HEADER] [varchar](MAX),
  [JOB_RUN_RESPONSE] [varchar](MAX),
  [JOB_FREQUENCY] [varchar](255),
  [JOB_STATUS] [varchar](100) ,
  [CREATED_BY] [varchar](255) ,	
  [CREATED_DATE] [datetime] ,
  [UPDATED_BY] [varchar](255) ,
  [UPDATED_DATE] [datetime] ,
  CONSTRAINT [PK_SERVER_JOB_HISTORY_ID] PRIMARY KEY CLUSTERED 
(
	[JOB_RUN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

ALTER TABLE [SERVER_JOB_HISTORY] ADD CONSTRAINT FK_SERVER_JOB_HISTORY_JOB_ID FOREIGN KEY (JOB_ID) REFERENCES SERVER_JOB (JOB_ID);
GO

CREATE TABLE [SERVER_QZ_CALENDARS] (
  [SCHED_NAME] [VARCHAR] (120)  NOT NULL ,
  [CALENDAR_NAME] [VARCHAR] (200)  NOT NULL ,
  [CALENDAR] [IMAGE] NOT NULL
) ON [PRIMARY]
GO

CREATE TABLE [SERVER_QZ_CRON_TRIGGERS] (
  [SCHED_NAME] [VARCHAR] (120)  NOT NULL ,
  [TRIGGER_NAME] [VARCHAR] (200)  NOT NULL ,
  [TRIGGER_GROUP] [VARCHAR] (200)  NOT NULL ,
  [CRON_EXPRESSION] [VARCHAR] (120)  NOT NULL ,
  [TIME_ZONE_ID] [VARCHAR] (80) 
) ON [PRIMARY]
GO

CREATE TABLE [SERVER_QZ_FIRED_TRIGGERS] (
  [SCHED_NAME] [VARCHAR] (120)  NOT NULL ,
  [ENTRY_ID] [VARCHAR] (95)  NOT NULL ,
  [TRIGGER_NAME] [VARCHAR] (200)  NOT NULL ,
  [TRIGGER_GROUP] [VARCHAR] (200)  NOT NULL ,
  [INSTANCE_NAME] [VARCHAR] (200)  NOT NULL ,
  [FIRED_TIME] [BIGINT] NOT NULL ,
  [SCHED_TIME] [BIGINT] NOT NULL ,
  [PRIORITY] [INTEGER] NOT NULL ,
  [STATE] [VARCHAR] (16)  NOT NULL,
  [JOB_NAME] [VARCHAR] (200)  NULL ,
  [JOB_GROUP] [VARCHAR] (200)  NULL ,
  [IS_NONCONCURRENT] [VARCHAR] (1)  NULL ,
  [REQUESTS_RECOVERY] [VARCHAR] (1)  NULL 
) ON [PRIMARY]
GO

CREATE TABLE [SERVER_QZ_PAUSED_TRIGGER_GRPS] (
  [SCHED_NAME] [VARCHAR] (120)  NOT NULL ,
  [TRIGGER_GROUP] [VARCHAR] (200)  NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [SERVER_QZ_SCHEDULER_STATE] (
  [SCHED_NAME] [VARCHAR] (120)  NOT NULL ,
  [INSTANCE_NAME] [VARCHAR] (200)  NOT NULL ,
  [LAST_CHECKIN_TIME] [BIGINT] NOT NULL ,
  [CHECKIN_INTERVAL] [BIGINT] NOT NULL
) ON [PRIMARY]
GO

CREATE TABLE [SERVER_QZ_LOCKS] (
  [SCHED_NAME] [VARCHAR] (120)  NOT NULL ,
  [LOCK_NAME] [VARCHAR] (40)  NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [SERVER_QZ_JOB_DETAILS] (
  [SCHED_NAME] [VARCHAR] (120)  NOT NULL ,
  [JOB_NAME] [VARCHAR] (200)  NOT NULL ,
  [JOB_GROUP] [VARCHAR] (200)  NOT NULL ,
  [DESCRIPTION] [VARCHAR] (250) NULL ,
  [JOB_CLASS_NAME] [VARCHAR] (250)  NOT NULL ,
  [IS_DURABLE] [VARCHAR] (1)  NOT NULL ,
  [IS_NONCONCURRENT] [VARCHAR] (1)  NOT NULL ,
  [IS_UPDATE_DATA] [VARCHAR] (1)  NOT NULL ,
  [REQUESTS_RECOVERY] [VARCHAR] (1)  NOT NULL ,
  [JOB_DATA] [IMAGE] NULL
) ON [PRIMARY]
GO

CREATE TABLE [SERVER_QZ_SIMPLE_TRIGGERS] (
  [SCHED_NAME] [VARCHAR] (120)  NOT NULL ,
  [TRIGGER_NAME] [VARCHAR] (200)  NOT NULL ,
  [TRIGGER_GROUP] [VARCHAR] (200)  NOT NULL ,
  [REPEAT_COUNT] [BIGINT] NOT NULL ,
  [REPEAT_INTERVAL] [BIGINT] NOT NULL ,
  [TIMES_TRIGGERED] [BIGINT] NOT NULL
) ON [PRIMARY]
GO

CREATE TABLE [SERVER_QZ_SIMPROP_TRIGGERS] (
  [SCHED_NAME] [VARCHAR] (120)  NOT NULL ,
  [TRIGGER_NAME] [VARCHAR] (200)  NOT NULL ,
  [TRIGGER_GROUP] [VARCHAR] (200)  NOT NULL ,
  [STR_PROP_1] [VARCHAR] (512) NULL,
  [STR_PROP_2] [VARCHAR] (512) NULL,
  [STR_PROP_3] [VARCHAR] (512) NULL,
  [INT_PROP_1] [INT] NULL,
  [INT_PROP_2] [INT] NULL,
  [LONG_PROP_1] [BIGINT] NULL,
  [LONG_PROP_2] [BIGINT] NULL,
  [DEC_PROP_1] [NUMERIC] (13,4) NULL,
  [DEC_PROP_2] [NUMERIC] (13,4) NULL,
  [BOOL_PROP_1] [VARCHAR] (1) NULL,
  [BOOL_PROP_2] [VARCHAR] (1) NULL,
) ON [PRIMARY]
GO

CREATE TABLE [SERVER_QZ_BLOB_TRIGGERS] (
  [SCHED_NAME] [VARCHAR] (120)  NOT NULL ,
  [TRIGGER_NAME] [VARCHAR] (200)  NOT NULL ,
  [TRIGGER_GROUP] [VARCHAR] (200)  NOT NULL ,
  [BLOB_DATA] [IMAGE] NULL
) ON [PRIMARY]
GO

CREATE TABLE [SERVER_QZ_TRIGGERS] (
  [SCHED_NAME] [VARCHAR] (120)  NOT NULL ,
  [TRIGGER_NAME] [VARCHAR] (200)  NOT NULL ,
  [TRIGGER_GROUP] [VARCHAR] (200)  NOT NULL ,
  [JOB_NAME] [VARCHAR] (200)  NOT NULL ,
  [JOB_GROUP] [VARCHAR] (200)  NOT NULL ,
  [DESCRIPTION] [VARCHAR] (250) NULL ,
  [NEXT_FIRE_TIME] [BIGINT] NULL ,
  [PREV_FIRE_TIME] [BIGINT] NULL ,
  [PRIORITY] [INTEGER] NULL ,
  [TRIGGER_STATE] [VARCHAR] (16)  NOT NULL ,
  [TRIGGER_TYPE] [VARCHAR] (8)  NOT NULL ,
  [START_TIME] [BIGINT] NOT NULL ,
  [END_TIME] [BIGINT] NULL ,
  [CALENDAR_NAME] [VARCHAR] (200)  NULL ,
  [MISFIRE_INSTR] [SMALLINT] NULL ,
  [JOB_DATA] [IMAGE] NULL
) ON [PRIMARY]
GO

ALTER TABLE [SERVER_QZ_CALENDARS] WITH NOCHECK ADD
  CONSTRAINT [PK_SERVER_QZ_CALENDARS] PRIMARY KEY  CLUSTERED
  (
    [SCHED_NAME],
    [CALENDAR_NAME]
  )  ON [PRIMARY]
GO

ALTER TABLE [SERVER_QZ_CRON_TRIGGERS] WITH NOCHECK ADD
  CONSTRAINT [PK_SERVER_QZ_CRON_TRIGGERS] PRIMARY KEY  CLUSTERED
  (
    [SCHED_NAME],
    [TRIGGER_NAME],
    [TRIGGER_GROUP]
  )  ON [PRIMARY]
GO

ALTER TABLE [SERVER_QZ_FIRED_TRIGGERS] WITH NOCHECK ADD
  CONSTRAINT [PK_SERVER_QZ_FIRED_TRIGGERS] PRIMARY KEY  CLUSTERED
  (
    [SCHED_NAME],
    [ENTRY_ID]
  )  ON [PRIMARY]
GO

ALTER TABLE [SERVER_QZ_PAUSED_TRIGGER_GRPS] WITH NOCHECK ADD
  CONSTRAINT [PK_SERVER_QZ_PAUSED_TRIGGER_GRPS] PRIMARY KEY  CLUSTERED
  (
    [SCHED_NAME],
    [TRIGGER_GROUP]
  )  ON [PRIMARY]
GO

ALTER TABLE [SERVER_QZ_SCHEDULER_STATE] WITH NOCHECK ADD
  CONSTRAINT [PK_SERVER_QZ_SCHEDULER_STATE] PRIMARY KEY  CLUSTERED
  (
    [SCHED_NAME],
    [INSTANCE_NAME]
  )  ON [PRIMARY]
GO

ALTER TABLE [SERVER_QZ_LOCKS] WITH NOCHECK ADD
  CONSTRAINT [PK_SERVER_QZ_LOCKS] PRIMARY KEY  CLUSTERED
  (
    [SCHED_NAME],
    [LOCK_NAME]
  )  ON [PRIMARY]
GO

ALTER TABLE [SERVER_QZ_JOB_DETAILS] WITH NOCHECK ADD
  CONSTRAINT [PK_SERVER_QZ_JOB_DETAILS] PRIMARY KEY  CLUSTERED
  (
    [SCHED_NAME],
    [JOB_NAME],
    [JOB_GROUP]
  )  ON [PRIMARY]
GO

ALTER TABLE [SERVER_QZ_SIMPLE_TRIGGERS] WITH NOCHECK ADD
  CONSTRAINT [PK_SERVER_QZ_SIMPLE_TRIGGERS] PRIMARY KEY  CLUSTERED
  (
    [SCHED_NAME],
    [TRIGGER_NAME],
    [TRIGGER_GROUP]
  )  ON [PRIMARY]
GO

ALTER TABLE [SERVER_QZ_SIMPROP_TRIGGERS] WITH NOCHECK ADD
  CONSTRAINT [PK_SERVER_QZ_SIMPROP_TRIGGERS] PRIMARY KEY  CLUSTERED
  (
    [SCHED_NAME],
    [TRIGGER_NAME],
    [TRIGGER_GROUP]
  )  ON [PRIMARY]
GO

ALTER TABLE [SERVER_QZ_TRIGGERS] WITH NOCHECK ADD
  CONSTRAINT [PK_SERVER_QZ_TRIGGERS] PRIMARY KEY  CLUSTERED
  (
    [SCHED_NAME],
    [TRIGGER_NAME],
    [TRIGGER_GROUP]
  )  ON [PRIMARY]
GO

ALTER TABLE [SERVER_QZ_CRON_TRIGGERS] ADD
  CONSTRAINT [FK_SERVER_QZ_CRON_TRIGGERS_SERVER_QZ_TRIGGERS] FOREIGN KEY
  (
    [SCHED_NAME],
    [TRIGGER_NAME],
    [TRIGGER_GROUP]
  ) REFERENCES [SERVER_QZ_TRIGGERS] (
    [SCHED_NAME],
    [TRIGGER_NAME],
    [TRIGGER_GROUP]
  ) ON DELETE CASCADE
GO

ALTER TABLE [SERVER_QZ_SIMPLE_TRIGGERS] ADD
  CONSTRAINT [FK_SERVER_QZ_SIMPLE_TRIGGERS_SERVER_QZ_TRIGGERS] FOREIGN KEY
  (
    [SCHED_NAME],
    [TRIGGER_NAME],
    [TRIGGER_GROUP]
  ) REFERENCES [SERVER_QZ_TRIGGERS] (
    [SCHED_NAME],
    [TRIGGER_NAME],
    [TRIGGER_GROUP]
  ) ON DELETE CASCADE
GO

ALTER TABLE [SERVER_QZ_SIMPROP_TRIGGERS] ADD
  CONSTRAINT [FK_SERVER_QZ_SIMPROP_TRIGGERS_SERVER_QZ_TRIGGERS] FOREIGN KEY
  (
    [SCHED_NAME],
    [TRIGGER_NAME],
    [TRIGGER_GROUP]
  ) REFERENCES [SERVER_QZ_TRIGGERS] (
    [SCHED_NAME],
    [TRIGGER_NAME],
    [TRIGGER_GROUP]
  ) ON DELETE CASCADE
GO

ALTER TABLE [SERVER_QZ_TRIGGERS] ADD
  CONSTRAINT [FK_SERVER_QZ_TRIGGERS_SERVER_QZ_JOB_DETAILS] FOREIGN KEY
  (
    [SCHED_NAME],
    [JOB_NAME],
    [JOB_GROUP]
  ) REFERENCES [SERVER_QZ_JOB_DETAILS] (
    [SCHED_NAME],
    [JOB_NAME],
    [JOB_GROUP]
  )
GO


insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.scheduler.skipUpdateCheck', 'true', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.dataSource', 'mobileFabricQuartzDS', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.scheduler.instanceId', 'AUTO', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.acquireTriggersWithinLock', 'true', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.scheduler.instanceName', 'MobileFabric_Scheduler', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.class', 'org.quartz.impl.jdbcjobstore.JobStoreTX', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.threadPool.class', 'org.quartz.simpl.SimpleThreadPool', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.driverDelegateClass', 'org.quartz.impl.jdbcjobstore.MSSQLDelegate', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.isClustered', 'false', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.threadPool.threadCount', '5', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.useProperties', 'false', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.tablePrefix', 'SERVER_QZ_', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.misfireThreshold', '60000', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('org.quartz.jobStore.selectWithLockSQL', 'SELECT LOCK_NAME FROM {0}LOCKS WITH (UPDLOCK,ROWLOCK) WHERE LOCK_NAME=?', 'MobileFabricJob', getdate(), getdate());

insert into [server_configuration](prop_name, prop_value, prop_type, created_date, updated_date) values('SERVER_CLEANUP_JOB_FREQUENCY', '0 0 0 1/1 * ? *', 'MobileFabricJob', getdate(), getdate());