CREATE TABLE [server_log_devicerequestdata](
  [request_id] [varchar](50) NOT NULL,
  [app_id] [varchar](50),  
  [device_id] [varchar](255),
  [user_id] [varchar](128),
  [created_by] [varchar](255) ,	
  [created_date] [datetime] ,
  [updated_by] [varchar](255) ,
  [updated_date] [datetime] ,
  [request_method] [varchar](50),
  [request_size] [int] ,
  [payload] [varbinary](MAX),
   CONSTRAINT [pk_request_id] PRIMARY KEY([request_id])
);
GO

CREATE TABLE [server_log_deviceresponsedata](
  [request_id] [varchar](50) NOT NULL,
  [created_by] [varchar](255) ,	
  [created_date] [datetime] ,
  [updated_by] [varchar](255) ,
  [updated_date] [datetime] ,
  [opstatus] [int] ,
  [payload] [varbinary](MAX),
  [response_size] [int] ,
   CONSTRAINT [fk_log_responseData] FOREIGN KEY ([request_id])
  REFERENCES [server_log_devicerequestdata] ([request_id]) ON DELETE CASCADE);
GO

CREATE TABLE [server_log_events](
  [request_id] [varchar](50) NOT NULL,
  [created_by] [varchar](255) ,	
  [created_date] [datetime] ,
  [updated_by] [varchar](255) ,
  [updated_date] [datetime] ,
  [event_type] [varchar](50) ,
  [payload] [varbinary](MAX),
   CONSTRAINT [fk_log_datasource] FOREIGN KEY ([request_id])
  REFERENCES [server_log_devicerequestdata] ([request_id]) ON DELETE CASCADE);
  GO
  
  insert into [server_configuration](prop_name, prop_value, created_date , updated_date) values('KONY_SERVER_TRACELOGS_LEVEL','OFF', getdate() ,getdate());
  GO