CREATE TABLE [server_timer_metrics] (
  [service_name] varchar(255) NOT NULL,
  [service_version] varchar(25) NOT NULL,
  [parent_service_name] varchar(255),
  [operation_name] varchar(255) NOT NULL,
  [service_category] varchar(35) NOT NULL,
  [service_type] varchar(35) NOT NULL,
  [verb] varchar(25) NOT NULL,
  [instance_id] varchar(35) NOT NULL,
  [count] int,
  [service_min] decimal(9,3),
  [service_max] decimal(9,3),
  [service_mean] decimal(9,3),
  [service_stddev] decimal(9,3),
  [pre_processor_min] decimal(9,3),
  [pre_processor_max] decimal(9,3),
  [pre_processor_mean] decimal(9,3),
  [pre_processor_stddev] decimal(9,3),
  [post_processor_min] decimal(9,3),
  [post_processor_max] decimal(9,3),
  [post_processor_mean] decimal(9,3),
  [post_processor_stddev] decimal(9,3),
  [request_mapper_min] decimal(9,3),
  [request_mapper_max] decimal(9,3),
  [request_mapper_mean] decimal(9,3),
  [request_mapper_stddev] decimal(9,3),
  [response_mapper_min] decimal(9,3),
  [response_mapper_max] decimal(9,3),
  [response_mapper_mean] decimal(9,3),
  [response_mapper_stddev] decimal(9,3),
  [backend_request_min] decimal(9,3),
  [backend_request_max] decimal(9,3),
  [backend_request_mean] decimal(9,3),
  [backend_request_stddev] decimal(9,3),
  [parsing_min] decimal(9,3),
  [parsing_max] decimal(9,3),
  [parsing_mean] decimal(9,3),
  [parsing_stddev] decimal(9,3),
  [url_provider_processing_min] decimal(9,3),
  [url_provider_processing_max] decimal(9,3),
  [url_provider_processing_mean] decimal(9,3),
  [url_provider_processing_stddev] decimal(9,3),
  [timestamp] DATETIME NOT NULL
);
GO

create index idx_servermetrics_inst_id on server_timer_metrics(instance_id)
GO

create index idx_servermetrics_ts on server_timer_metrics(timestamp)
GO
