	CREATE TABLE webapp
  (
     [webapp_id]      BIGINT NOT NULL identity,
     [webapp_name]    VARCHAR(64) UNIQUE,
     [webapp_version] VARCHAR(16),
     [webapp_zip_name]    VARCHAR(64),
	 [webapp_channel]    VARCHAR(128),
     [webapp_properties]  VARCHAR(max),
     [created_by]     VARCHAR(64),
     [created_date]   DATETIME2(0),
     [updated_by]     VARCHAR(64),
     [updated_date]   DATETIME2(0),
     [col1] 		VARCHAR(64),
     [col2] 		VARCHAR(64),
     [col3] 		VARCHAR(64),
     [col4] 		VARCHAR(64),
     [col5] 		VARCHAR(64),
     PRIMARY KEY([webapp_id])
  );
  GO
  
CREATE TABLE webapp_asset
  (
     [webapp_asset_id]      BIGINT NOT NULL identity,
     [webapp_asset_content] VARBINARY(max),
     [webapp_asset_name]    VARCHAR(64),
     [webapp_asset_type]    VARCHAR(16) DEFAULT 'JAR',
     [created_by]           VARCHAR(64),
     [created_date]         DATETIME2(0),
     [updated_by]           VARCHAR(64),
     [updated_date]         DATETIME2(0),
     [col1] 		VARCHAR(64),
     [col2] 		VARCHAR(64),
     [col3] 		VARCHAR(64),
     [col4] 		VARCHAR(64),
     [col5] 		VARCHAR(64),
     PRIMARY KEY ([webapp_asset_id])
  ); 
  GO
  
CREATE TABLE webapp_content
  (
     [webapp_content_id]   BIGINT NOT NULL identity,
     [webapp_id]           BIGINT NOT NULL,
     [webapp_content_part] VARBINARY(max),
     [webapp_resource_path]      VARCHAR(255) NOT NULL,
     [created_by]     VARCHAR(64),
     [created_date]   DATETIME2(0),
     [updated_by]     VARCHAR(64),
     [updated_date]   DATETIME2(0),
     [col1] 		VARCHAR(64),
     [col2] 		VARCHAR(64),
     [col3] 		VARCHAR(64),
     [col4] 		VARCHAR(64),
     [col5] 		VARCHAR(64),
     CONSTRAINT [fk_webapp_content_id] FOREIGN KEY (webapp_id) REFERENCES webapp(webapp_id) 
	 ON DELETE CASCADE,
     PRIMARY KEY ([webapp_content_id])
  );
  GO
  
  create index idx_webapp_content_webapp_id on webapp_content(webapp_id)
  GO
  
  CREATE TABLE webapp_asset_info
  (
     [webapp_id]       BIGINT NOT NULL,
     [webapp_asset_id] BIGINT NOT NULL,
     CONSTRAINT [fk_asset_info_webapp_id] FOREIGN KEY (webapp_id) REFERENCES webapp(webapp_id),
     CONSTRAINT [fk_asset_info_webapp_asset_id] FOREIGN KEY (webapp_asset_id) REFERENCES webapp_asset(webapp_asset_id)
  );
  GO
  create index idx_asset_info_webapp_id on webapp_asset_info(webapp_id)
  GO
  create index idx_asset_info_webapp_asset_id on webapp_asset_info(webapp_asset_id)
  GO