DROP TABLE [server_timer_metrics]
GO

CREATE TABLE [server_timer_metrics] (
  [service_name] varchar(255) NOT NULL,
  [service_version] varchar(25) NOT NULL,
  [parent_service_name] varchar(255),
  [operation_name] varchar(255) NOT NULL,
  [service_category] varchar(35) NOT NULL,
  [service_type] varchar(35) NOT NULL,
  [verb] varchar(25) NOT NULL,
  [instance_id] varchar(35) NOT NULL,
  [count] int,
  [service_min] int,
  [service_max] int,
  [service_mean] int,
  [service_stddev] int,
  [pre_processor_min] int,
  [pre_processor_max] int,
  [pre_processor_mean] int,
  [pre_processor_stddev] int,
  [post_processor_min] int,
  [post_processor_max] int,
  [post_processor_mean] int,
  [post_processor_stddev] int,
  [request_mapper_min] int,
  [request_mapper_max] int,
  [request_mapper_mean] int,
  [request_mapper_stddev] int,
  [response_mapper_min] int,
  [response_mapper_max] int,
  [response_mapper_mean] int,
  [response_mapper_stddev] int,
  [backend_request_min] int,
  [backend_request_max] int,
  [backend_request_mean] int,
  [backend_request_stddev] int,
  [parsing_min] int,
  [parsing_max] int,
  [parsing_mean] int,
  [parsing_stddev] int,
  [url_provider_processing_min] int,
  [url_provider_processing_max] int,
  [url_provider_processing_mean] int,
  [url_provider_processing_stddev] int,
  [timestamp] DATETIME NOT NULL
);
GO

create index idx_servermetrics_inst_id on server_timer_metrics(instance_id)
GO

create index idx_servermetrics_ts on server_timer_metrics(timestamp)
GO
