ALTER TABLE upload_cache ADD CONSTRAINT upload_cache_created_date DEFAULT CURRENT_TIMESTAMP FOR created_date
GO

CREATE TABLE [upload_cache1] (
  [id] [numeric](20, 0) IDENTITY(1,1),
  [req_hash] [varchar](50)  NOT NULL,
  [response] varbinary(MAX) ,
  [iserror] tinyint default 0 NOT NULL ,
  [firsthittime] [numeric](20, 0) NOT NULL,
  [created_date] [datetime] default CURRENT_TIMESTAMP,
  [updated_date] [datetime],
  [updated_by] [varchar](50),
  [created_by] [varchar](50),
  constraint [pk_upload_cache1_id] PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 constraint uk_upload_cache1_req_hash UNIQUE NONCLUSTERED
(
	[req_hash] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
)

GO

CREATE TABLE [upload_cache2] (
  [id] [numeric](20, 0) IDENTITY(1,1),
  [req_hash] [varchar](50)  NOT NULL,
  [response] varbinary(MAX) ,
  [iserror] tinyint default 0 NOT NULL ,
  [firsthittime] [numeric](20, 0) NOT NULL,
  [created_date] [datetime],
  [updated_date] [datetime],
  [updated_by] [varchar](50),
  [created_by] [varchar](50),
  constraint [pk_upload_cache2_id] PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 constraint uk_upload_cache2_req_hash UNIQUE NONCLUSTERED
(
	[req_hash] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
)

GO

create VIEW upload_cache_view AS
	SELECT
        id, req_hash, response, iserror, firsthittime
    FROM
        upload_cache
    UNION all SELECT
        id, req_hash, response, iserror, firsthittime
    FROM
        upload_cache1
    UNION all SELECT
        id, req_hash, response, iserror, firsthittime
    FROM
        upload_cache2

GO